/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.DBObjectToHashingindexspace;
import be.SIRAPRISE.client.jsba.DBObjectToStoragespace;
import be.SIRAPRISE.client.jsba.ForRelvars;
import be.SIRAPRISE.client.jsba.HashingindexspaceToDBObject;
import be.SIRAPRISE.client.jsba.StoragespaceToDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

@ForRelvars(relvarNames={"HashingIndexSpace", "StorageSpace"})
public final class HashingIndexSpace
extends AbstractUpdatableDBObject
implements DBObjectToHashingindexspace,
DBObjectToStoragespace,
HashingindexspaceToDBObject,
StoragespaceToDBObject {
    private int extentsCount;
    private String fileName;
    private int pageCount;
    private HashingIndexSpace preUpdateState;
    private int storageSpaceID;

    public HashingIndexSpace() {
    }

    public HashingIndexSpace(String fileName, int storageSpaceID, int pageCount) {
        this.fileName = fileName.toUpperCase();
        this.storageSpaceID = storageSpaceID;
        this.pageCount = pageCount;
    }

    public HashingIndexSpace(String fileName, int storageSpaceID, int pageCount, int extentsCount) {
        this(fileName, storageSpaceID, pageCount);
        this.extentsCount = extentsCount;
    }

    public final int getExtentsCount() {
        return this.extentsCount;
    }

    public final String getFileName() {
        return this.fileName;
    }

    @Override
    public final String getHashingindexspaceStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    @Override
    public final String getHashingindexspaceFilename() {
        return BracketParser.meta(this.fileName);
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    @Override
    public final UpdatableDBObject getPreUpdateState() {
        return this.preUpdateState;
    }

    @Override
    public String getStoragespaceExtentscount() {
        return Integer.toString(this.extentsCount);
    }

    public final String getStoragespaceextentsExtentscount() {
        return Integer.toString(this.extentsCount);
    }

    public final String getStoragespaceextentsFilename() {
        return BracketParser.meta(this.fileName);
    }

    public final String getStoragespaceextentsStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    @Override
    public final String getStoragespaceFilename() {
        return BracketParser.meta(this.fileName);
    }

    public final int getStorageSpaceID() {
        return this.storageSpaceID;
    }

    @Override
    public final String getStoragespacePagecount() {
        return Integer.toString(this.pageCount);
    }

    @Override
    public final String getStoragespaceStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    public final void setExtentsCount(int extentsCount) {
        this.extentsCount = extentsCount;
    }

    @Override
    public final void setExtentscountFromDB(String extentsCount) {
        this.extentsCount = Integer.parseInt(extentsCount);
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName.toUpperCase();
    }

    @Override
    public final void setFilenameFromDB(String fileName) {
        try {
            this.fileName = BracketParser.unMeta(fileName).toUpperCase();
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    @Override
    public final void setPagecountFromDB(String pageCount) {
        this.pageCount = Integer.parseInt(pageCount);
    }

    @Override
    public final void setPreUpdateState() {
        this.preUpdateState = new HashingIndexSpace(this.fileName, this.storageSpaceID, this.extentsCount);
    }

    public final void setStorageSpaceID(int storageSpaceID) {
        this.storageSpaceID = storageSpaceID;
    }

    @Override
    public final void setStoragespaceidFromDB(String storageSpaceID) {
        this.storageSpaceID = Integer.parseInt(storageSpaceID);
    }
}

