/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.DBObjectToRelvar;
import be.SIRAPRISE.client.jsba.ForRelvars;
import be.SIRAPRISE.client.jsba.RelvarToDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

@ForRelvars(relvarNames={"Relvar"})
public final class Relvar
extends AbstractUpdatableDBObject
implements DBObjectToRelvar,
RelvarToDBObject {
    private String name;
    private String predicate;
    private Relvar preUpdateState;

    public Relvar() {
        this("", "");
    }

    public Relvar(String name, String predicate) {
        this.name = name.toUpperCase();
        this.predicate = predicate;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPredicate() {
        return this.predicate;
    }

    @Override
    public UpdatableDBObject getPreUpdateState() {
        return this.preUpdateState;
    }

    @Override
    public String getRelvarRelvarname() {
        return this.name;
    }

    @Override
    public String getRelvarRelvarpredicate() {
        return BracketParser.meta(this.predicate);
    }

    public final void setName(String name) {
        this.name = name.toUpperCase();
    }

    public final void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    @Override
    public void setPreUpdateState() {
        this.preUpdateState = new Relvar(this.name, this.predicate);
    }

    @Override
    public void setRelvarnameFromDB(String relvarname) {
        this.name = relvarname.toUpperCase();
    }

    @Override
    public void setRelvarpredicateFromDB(String relvarpredicate) {
        try {
            this.predicate = BracketParser.unMeta(relvarpredicate);
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
    }
}

