/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.DBObjectToStoragespace;
import be.SIRAPRISE.client.jsba.StoragespaceToDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

public final class StorageSpace
extends AbstractUpdatableDBObject
implements DBObjectToStoragespace,
StoragespaceToDBObject {
    private int extentsCount;
    private String fileName;
    private int pageCount;
    private StorageSpace preUpdateState;
    private int storageSpaceID;

    public StorageSpace() {
    }

    public StorageSpace(String fileName, int storageSpaceID, int pageCount, int extentsCount) {
        this.fileName = fileName.toUpperCase();
        this.pageCount = pageCount;
        this.storageSpaceID = storageSpaceID;
        this.extentsCount = extentsCount;
    }

    public final int getExtentsCount() {
        return this.extentsCount;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    @Override
    public final UpdatableDBObject getPreUpdateState() {
        return this.preUpdateState;
    }

    @Override
    public String getStoragespaceExtentscount() {
        return Integer.toString(this.extentsCount);
    }

    @Override
    public final String getStoragespaceFilename() {
        return BracketParser.meta(this.fileName);
    }

    public final int getStorageSpaceID() {
        return this.storageSpaceID;
    }

    @Override
    public final String getStoragespacePagecount() {
        return Integer.toString(this.pageCount);
    }

    @Override
    public final String getStoragespaceStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    public final void setExtentsCount(int extentsCount) {
        this.extentsCount = extentsCount;
    }

    @Override
    public void setExtentscountFromDB(String extentscount) {
        this.extentsCount = Integer.parseInt(extentscount);
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName.toUpperCase();
    }

    @Override
    public void setFilenameFromDB(String x) {
        try {
            this.fileName = BracketParser.unMeta(x).toUpperCase();
        }
        catch (InvalidEscapedCharacterException invalidEscapedCharacterException) {
            throw new IllegalArgumentException(x);
        }
        catch (MissingEscapedCharacterException missingEscapedCharacterException) {
            throw new IllegalArgumentException(x);
        }
    }

    public final void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    @Override
    public void setPagecountFromDB(String x) {
        this.pageCount = Integer.parseInt(x);
    }

    @Override
    public final void setPreUpdateState() {
        this.preUpdateState = new StorageSpace(this.fileName, this.pageCount, this.storageSpaceID, this.extentsCount);
    }

    public final void setStorageSpaceID(int storageSpaceID) {
        this.storageSpaceID = storageSpaceID;
    }

    @Override
    public final void setStoragespaceidFromDB(String x) {
        this.storageSpaceID = Integer.parseInt(x);
    }
}

