/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.DBObjectToStoragespace;
import be.SIRAPRISE.client.jsba.DBObjectToTreeindexspace;
import be.SIRAPRISE.client.jsba.ForRelvars;
import be.SIRAPRISE.client.jsba.StoragespaceToDBObject;
import be.SIRAPRISE.client.jsba.TreeindexspaceToDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

@ForRelvars(relvarNames={"TreeIndexSpace", "StorageSpace"})
public final class TreeIndexSpace
extends AbstractUpdatableDBObject
implements DBObjectToTreeindexspace,
DBObjectToStoragespace,
TreeindexspaceToDBObject,
StoragespaceToDBObject {
    private int extentsCount;
    private String fileName;
    private int pageCount;
    private TreeIndexSpace preUpdateState;
    private int storageSpaceID;

    public TreeIndexSpace() {
    }

    public TreeIndexSpace(String fileName, int storageSpaceID, int pageCount, int extentsCount) {
        this.fileName = fileName.toUpperCase();
        this.storageSpaceID = storageSpaceID;
        this.pageCount = pageCount;
        this.extentsCount = extentsCount;
    }

    public final int getExtentsCount() {
        return this.extentsCount;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    @Override
    public final UpdatableDBObject getPreUpdateState() {
        return this.preUpdateState;
    }

    @Override
    public String getStoragespaceExtentscount() {
        return Integer.toString(this.extentsCount);
    }

    @Override
    public String getStoragespaceFilename() {
        return BracketParser.meta(this.fileName);
    }

    public final int getStorageSpaceID() {
        return this.storageSpaceID;
    }

    @Override
    public String getStoragespacePagecount() {
        return Integer.toString(this.pageCount);
    }

    @Override
    public String getStoragespaceStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    @Override
    public final String getTreeindexspaceFilename() {
        return BracketParser.meta(this.fileName);
    }

    @Override
    public final String getTreeindexspaceStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    public final void setExtentsCount(int extentsCount) {
        this.extentsCount = extentsCount;
    }

    @Override
    public void setExtentscountFromDB(String extentscount) {
        this.extentsCount = Integer.parseInt(extentscount);
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName.toUpperCase();
    }

    @Override
    public final void setFilenameFromDB(String fileName) {
        try {
            this.fileName = BracketParser.unMeta(fileName).toUpperCase();
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    @Override
    public void setPagecountFromDB(String x) {
        this.pageCount = Integer.parseInt(x);
    }

    @Override
    public final void setPreUpdateState() {
        this.preUpdateState = new TreeIndexSpace(this.fileName, this.storageSpaceID, this.pageCount, this.extentsCount);
    }

    public final void setStorageSpaceID(int storageSpaceID) {
        this.storageSpaceID = storageSpaceID;
    }

    @Override
    public final void setStoragespaceidFromDB(String storageSpaceID) {
        this.storageSpaceID = Integer.parseInt(storageSpaceID);
    }
}

