/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ClientAuthenticationMessage;
import be.SIRAPRISE.messages.ClientAuthenticationMessageType;
import be.SIRAPRISE.messages.ClientAuthenticationMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ClientAuthenticationMessageTypeV1_0
extends ClientAuthenticationMessageType {
    private static final ClientAuthenticationMessageType instance = new ClientAuthenticationMessageTypeV1_0();

    static ClientAuthenticationMessageType getInstance() {
        return instance;
    }

    private ClientAuthenticationMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        String clientID = MyDataInputStream.getSmallUTFString(in);
        short byteCount = in.readShort();
        byte[] signature = MyDataInputStream.readExactNumberOfBytes(in, byteCount);
        return new ClientAuthenticationMessageV1_0(this, clientID, signature);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof ClientAuthenticationMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        ClientAuthenticationMessageV1_0 clientAuthenticationMessageV1_0 = (ClientAuthenticationMessageV1_0)message;
        MyDataOutputStream.writeSmallUTF(clientAuthenticationMessageV1_0.getClientID(), outputStream);
        byte[] signature = clientAuthenticationMessageV1_0.getSignature();
        outputStream.writeShort(signature.length);
        outputStream.write(signature);
    }

    @Override
    public ClientAuthenticationMessage message(String clientID, byte[] signature) {
        return new ClientAuthenticationMessageV1_0(this, clientID, signature);
    }
}

