/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ClientHelloMessage;
import be.SIRAPRISE.messages.ClientHelloMessageType;
import be.SIRAPRISE.messages.ClientHelloMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class ClientHelloMessageTypeV1_0
extends ClientHelloMessageType {
    private static final ClientHelloMessageType instance = new ClientHelloMessageTypeV1_0();

    static ClientHelloMessageType getInstance() {
        return instance;
    }

    private ClientHelloMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        int clientSignatureProtocolCount = in.readShort();
        HashSet<String> clientSignatureProtocols = new HashSet<String>();
        while (--clientSignatureProtocolCount >= 0) {
            short charLength = in.readShort();
            short byteLength = in.readShort();
            clientSignatureProtocols.add(MyDataInputStream.getUTFString(in, charLength, byteLength));
        }
        int clientEncryptionProtocolCount = in.readShort();
        HashSet<String> clientEncryptionProtocols = new HashSet<String>();
        while (--clientEncryptionProtocolCount >= 0) {
            short charLength = in.readShort();
            short byteLength = in.readShort();
            clientEncryptionProtocols.add(MyDataInputStream.getUTFString(in, charLength, byteLength));
        }
        long idleTime = in.readLong();
        short majorClientSiraPriseVersion = in.readShort();
        short minorClientSiraPriseVersion = in.readShort();
        return new ClientHelloMessageV1_0(this, clientSignatureProtocols, clientEncryptionProtocols, idleTime, new Version(majorClientSiraPriseVersion, minorClientSiraPriseVersion));
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof ClientHelloMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        ClientHelloMessageV1_0 clientHelloMessageV1_0 = (ClientHelloMessageV1_0)message;
        Set<String> clientSignatureProtocols = clientHelloMessageV1_0.getClientSignatureProtocolNames();
        outputStream.writeShort(clientSignatureProtocols.size());
        for (String clientSignatureProtocol : clientSignatureProtocols) {
            MyDataOutputStream.writeSmallUTF(clientSignatureProtocol, outputStream);
        }
        Set<String> clientEncryptionProtocols = clientHelloMessageV1_0.getClientCryptoProtocolNames();
        outputStream.writeShort(clientEncryptionProtocols.size());
        for (String clientEncryptionProtocol : clientEncryptionProtocols) {
            MyDataOutputStream.writeSmallUTF(clientEncryptionProtocol, outputStream);
        }
        outputStream.writeLong(clientHelloMessageV1_0.getIdleTime());
        outputStream.writeShort(clientHelloMessageV1_0.getClientSiraPriseVersion().getMajorVersion());
        outputStream.writeShort(clientHelloMessageV1_0.getClientSiraPriseVersion().getMinorVersion());
    }

    @Override
    public ClientHelloMessage message(Set<String> signatureAlgorithmNames, Set<String> encryptionProtocolNames, long requestConnectionIdleTime, Version version) {
        return new ClientHelloMessageV1_0(this, signatureAlgorithmNames, encryptionProtocolNames, requestConnectionIdleTime, version);
    }
}

