/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.ClientTuple;
import be.SIRAPRISE.client.DuplicateException;
import be.SIRAPRISE.client.Heading;
import be.SIRAPRISE.client.InsertionOrderRelation;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.AssignmentExecutedMessageV1_0;
import be.SIRAPRISE.messages.DmlExecutedMessageType;
import be.SIRAPRISE.messages.QueryExecutedMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.util.IntersectableHashMap;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Iterator;

public final class DmlExecutedMessageTypeV1_0
extends DmlExecutedMessageType {
    private static DmlExecutedMessageType instance = new DmlExecutedMessageTypeV1_0();

    static DmlExecutedMessageType getInstance() {
        return instance;
    }

    private DmlExecutedMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    private void readHeading(DataInputStream in, Heading heading) throws IOException, UTFDataFormatException {
        int degree = in.readInt();
        while (degree-- > 0) {
            String attributeName = MyDataInputStream.getSmallUTFString(in);
            String typeName = MyDataInputStream.getSmallUTFString(in);
            if (typeName.equalsIgnoreCase("RELATION")) {
                Heading rvaHeading = new Heading();
                this.readHeading(in, rvaHeading);
                try {
                    heading.add(attributeName, rvaHeading);
                }
                catch (DuplicateException duplicateException) {}
                continue;
            }
            try {
                heading.add(attributeName, typeName);
            }
            catch (DuplicateException duplicateException) {}
        }
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        byte b = in.readByte();
        if (b == 0) {
            return new AssignmentExecutedMessageV1_0(this);
        }
        Heading heading = new Heading();
        this.readHeading(in, heading);
        int count = in.readInt();
        InsertionOrderRelation relation = new InsertionOrderRelation(heading);
        try {
            while (true) {
                in.readShort();
                IntersectableHashMap<String, String> m = new IntersectableHashMap<String, String>();
                Iterator i_heading = heading.entrySet().iterator();
                while (i_heading.hasNext()) {
                    m.put((String)i_heading.next().getKey(), MyDataInputStream.getBigUTFString(in));
                }
                relation.addTupleWithoutHeadingCheck(new ClientTuple(m, heading));
            }
        }
        catch (EOFException eOFException) {
            if (count != relation.size()) {
                throw new IllegalArgumentException();
            }
            return new QueryExecutedMessageV1_0(relation);
        }
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (message instanceof AssignmentExecutedMessageV1_0) {
            outputStream.writeByte(0);
        } else {
            if (!(message instanceof QueryExecutedMessageV1_0)) {
                throw new IllegalArgumentException();
            }
            QueryExecutedMessageV1_0 queryExecutedMessageV1_0 = (QueryExecutedMessageV1_0)message;
            AbstractRelation relation = queryExecutedMessageV1_0.getRelation();
            Heading heading = relation.getHeading();
            outputStream.writeByte(1);
            heading.toStream1_0(outputStream);
            outputStream.writeInt(relation.size());
            Iterator<Tuple> i_relation = relation.iterator();
            while (i_relation.hasNext()) {
                outputStream.writeShort(61166);
                AbstractTuple t = (AbstractTuple)i_relation.next();
                Iterator i_heading = heading.entrySet().iterator();
                while (i_heading.hasNext()) {
                    MyDataOutputStream.writeBigUTF(t.escapedValue((String)i_heading.next().getKey()), outputStream);
                }
            }
        }
    }

    @Override
    public final ServerMessage getDmlExecutedMessage(AbstractRelation relation) {
        if (relation != null) {
            return new QueryExecutedMessageV1_0(relation);
        }
        return new AssignmentExecutedMessageV1_0(this);
    }
}

