/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.ServerAddCommand;
import be.SIRAPRISE.client.ServerAssertCommand;
import be.SIRAPRISE.client.ServerAssignmentCommand;
import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.ServerDeleteCommand;
import be.SIRAPRISE.client.ServerMultipleAssignmentCommand;
import be.SIRAPRISE.client.ServerSingleAssignmentCommand;
import be.SIRAPRISE.client.ServerUnassertCommand;
import be.SIRAPRISE.client.ServerUpdateCommand;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ExecuteAssignmentMessageType;
import be.SIRAPRISE.messages.ExecuteAssignmentMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.util.MyDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExecuteAssignmentMessageTypeV1_0
extends ExecuteAssignmentMessageType {
    private static ExecuteAssignmentMessageType instance = new ExecuteAssignmentMessageTypeV1_0();

    static ExecuteAssignmentMessageType getInstance() {
        return instance;
    }

    private ExecuteAssignmentMessageTypeV1_0() {
        super(Version.ONE_ONE, Version.ONE_FOUR);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        int count = in.readInt();
        ServerSingleAssignmentCommand[] cmds = new ServerSingleAssignmentCommand[count];
        int i = 0;
        while (i < count) {
            byte assignmentType = in.readByte();
            switch (assignmentType) {
                case 1: {
                    String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
                    String insert = MyDataInputStream.getBigUTFString(in);
                    cmds[i] = new ServerAddCommand(targetRelvarName, insert);
                    break;
                }
                case 2: {
                    String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
                    String delete = MyDataInputStream.getBigUTFString(in);
                    cmds[i] = new ServerDeleteCommand(targetRelvarName, delete);
                    break;
                }
                case 3: {
                    String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
                    String delete = MyDataInputStream.getBigUTFString(in);
                    String changes = MyDataInputStream.getBigUTFString(in);
                    cmds[i] = new ServerUpdateCommand(targetRelvarName, delete, changes);
                    break;
                }
                case 5: {
                    String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
                    String insert = MyDataInputStream.getBigUTFString(in);
                    cmds[i] = new ServerAssertCommand(targetRelvarName, insert);
                    break;
                }
                case 6: {
                    String targetRelvarName = MyDataInputStream.getSmallUTFString(in);
                    String insert = MyDataInputStream.getBigUTFString(in);
                    cmds[i] = new ServerUnassertCommand(targetRelvarName, insert);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++i;
        }
        return new ExecuteAssignmentMessageV1_0(this, count == 1 ? cmds[0] : new ServerMultipleAssignmentCommand(cmds));
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof ExecuteAssignmentMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        ((ExecuteAssignmentMessageV1_0)message).getAssignmentCommand().writeToStream(outputStream);
    }

    @Override
    public ServerMessage message(ServerCommand cmd) {
        return new ExecuteAssignmentMessageV1_0(this, (ServerAssignmentCommand)cmd);
    }

    @Override
    public ExecuteAssignmentMessageV1_0 message(ServerSingleAssignmentCommand[] cmds) {
        return new ExecuteAssignmentMessageV1_0(this, cmds.length == 1 ? cmds[0] : new ServerMultipleAssignmentCommand(cmds));
    }
}

