/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ExecuteMonitorCommandMessage;
import be.SIRAPRISE.messages.ExecuteMonitorCommandMessageType;
import be.SIRAPRISE.messages.ExecuteMonitorCommandMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.ServerMessageType;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExecuteMonitorCommandMessageTypeV1_0
extends ExecuteMonitorCommandMessageType {
    private static ServerMessageType instance = new ExecuteMonitorCommandMessageTypeV1_0();

    static ServerMessageType getInstance() {
        return instance;
    }

    private ExecuteMonitorCommandMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        String userID = MyDataInputStream.getSmallUTFString(in);
        boolean authenticatedByClient = in.readByte() == 1;
        String userAuthenticationAlgorithm = MyDataInputStream.getSmallUTFString(in);
        short signatureLength = in.readShort();
        byte[] signature = new byte[signatureLength];
        in.read(signature);
        String monitorCommand = MyDataInputStream.getBigUTFString(in);
        return new ExecuteMonitorCommandMessageV1_0(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature, monitorCommand);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof ExecuteMonitorCommandMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        ExecuteMonitorCommandMessageV1_0 executeMonitorCommandMessageV1_0 = (ExecuteMonitorCommandMessageV1_0)message;
        MyDataOutputStream.writeSmallUTF(executeMonitorCommandMessageV1_0.getUserID(), outputStream);
        outputStream.write(executeMonitorCommandMessageV1_0.isUserAuthenticatedByClient() ? 1 : 0);
        MyDataOutputStream.writeSmallUTF(executeMonitorCommandMessageV1_0.getUserAuthenticationAlgorithm(), outputStream);
        byte[] signature = executeMonitorCommandMessageV1_0.getSignature();
        outputStream.writeShort(signature.length);
        outputStream.write(signature);
        MyDataOutputStream.writeBigUTF(executeMonitorCommandMessageV1_0.getMonitorCommand(), outputStream);
    }

    @Override
    public ExecuteMonitorCommandMessage message(String monitorCommand, byte[] signature, String userAuthenticationAlgorithm, boolean authenticatedByClient, String userID) {
        return new ExecuteMonitorCommandMessageV1_0(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature, monitorCommand);
    }
}

