/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.ServerInquireCommand;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ExecuteQueryMessage;
import be.SIRAPRISE.messages.ExecuteQueryMessageType;
import be.SIRAPRISE.messages.ExecuteQueryMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class ExecuteQueryMessageTypeV1_0
extends ExecuteQueryMessageType {
    private static ExecuteQueryMessageType instance = new ExecuteQueryMessageTypeV1_0();

    static ExecuteQueryMessageType getInstance() {
        return instance;
    }

    private ExecuteQueryMessageTypeV1_0() {
        super(Version.ONE_ONE, Version.ONE_FOUR);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        String query = MyDataInputStream.getBigUTFString(in);
        int count = in.readInt();
        LinkedList<String> orderByAttributeNames = new LinkedList<String>();
        int i = 0;
        while (i < count) {
            orderByAttributeNames.addLast(MyDataInputStream.getSmallUTFString(in));
        }
        return new ExecuteQueryMessageV1_0(this, query, orderByAttributeNames);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof ExecuteQueryMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        ExecuteQueryMessageV1_0 queryMessage = (ExecuteQueryMessageV1_0)message;
        MyDataOutputStream.writeBigUTF(queryMessage.getQuery(), outputStream);
        List<String> orderByAttributeNames = queryMessage.getOrderByAttributeNames();
        outputStream.writeInt(orderByAttributeNames.size());
        for (String orderByAttributeName : orderByAttributeNames) {
            MyDataOutputStream.writeSmallUTF(orderByAttributeName, outputStream);
        }
    }

    @Override
    public ServerMessage message(ServerCommand cmd) {
        return new ExecuteQueryMessageV1_0(this, cmd.getCommandParametersText(), ((ServerInquireCommand)cmd).getOrderByAttributeNames());
    }

    @Override
    public ExecuteQueryMessage message(String query, List<String> orderByAttributeNames) {
        return new ExecuteQueryMessageV1_0(this, query, orderByAttributeNames);
    }
}

