/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.Messages;
import be.SIRAPRISE.messages.ServerHelloMessage;
import be.SIRAPRISE.messages.ServerHelloMessageType;
import be.SIRAPRISE.messages.ServerHelloMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.ServerMessageType;
import be.SIRAPRISE.security.JCECipher;
import be.SIRAPRISE.security.ProprietaryOrJCECipher;
import be.SIRAPRISE.security.SPE;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public final class ServerHelloMessageTypeV1_0
extends ServerHelloMessageType {
    private static final ServerMessageType instance = new ServerHelloMessageTypeV1_0();

    static ServerMessageType getInstance() {
        return instance;
    }

    private ServerHelloMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        byte clientEncryptionProtocolIndicator;
        Signature clientSignatureProtocol = null;
        JCECipher cryptoProtocol = null;
        byte clientSignatureProtocolIndicator = in.readByte();
        if (clientSignatureProtocolIndicator != 0) {
            String clientSignatureProtocolName = MyDataInputStream.getSmallUTFString(in);
            try {
                clientSignatureProtocol = Signature.getInstance(clientSignatureProtocolName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(Messages.getString("ServerHelloMessageTypeV1_0.SignatureProtocolCriticalFailure"));
            }
        }
        if ((clientEncryptionProtocolIndicator = in.readByte()) != 0) {
            String clientCryptoProtocolName = MyDataInputStream.getSmallUTFString(in);
            try {
                cryptoProtocol = new JCECipher(Cipher.getInstance(clientCryptoProtocolName));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (clientCryptoProtocolName.equalsIgnoreCase("SPE")) {
                    cryptoProtocol = new SPE();
                }
                throw new IOException(Messages.getString("ServerHelloMessageTypeV1_0.EncryptionProtocolCriticalFailure"));
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new IOException(Messages.getString("ServerHelloMessageTypeV1_0.EncryptionProtocolCriticalFailure"));
            }
            cryptoProtocol.getPublishedKey(in);
        }
        long idleTime = in.readLong();
        short majorClientSiraPriseVersion = in.readShort();
        short minorClientSiraPriseVersion = in.readShort();
        LinkedHashSet<String> alternativeSigningProtocols = new LinkedHashSet<String>();
        int alternativeSigningProtocolsCount = in.readShort();
        while (alternativeSigningProtocolsCount-- > 0) {
            String alternativeSigningProtocolName = MyDataInputStream.getSmallUTFString(in);
            alternativeSigningProtocols.add(alternativeSigningProtocolName);
        }
        return new ServerHelloMessageV1_0(this, clientSignatureProtocol, (ProprietaryOrJCECipher)cryptoProtocol, idleTime, new Version(majorClientSiraPriseVersion, minorClientSiraPriseVersion), alternativeSigningProtocols);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof ServerHelloMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        ServerHelloMessageV1_0 serverHelloMessageV1_0 = (ServerHelloMessageV1_0)message;
        Signature sp = serverHelloMessageV1_0.getSigningProtocol();
        if (sp == null) {
            outputStream.writeByte(0);
        } else {
            outputStream.writeByte(1);
            MyDataOutputStream.writeSmallUTF(sp.getAlgorithm(), outputStream);
        }
        ProprietaryOrJCECipher encryptionDecryptionProtocol = serverHelloMessageV1_0.getCryptoProtocol();
        if (encryptionDecryptionProtocol == null) {
            outputStream.writeByte(0);
        } else {
            outputStream.writeByte(1);
            MyDataOutputStream.writeSmallUTF(encryptionDecryptionProtocol.getAlgorithm(), outputStream);
            encryptionDecryptionProtocol.publishKey(outputStream);
        }
        outputStream.writeLong(serverHelloMessageV1_0.getIdleTime());
        outputStream.writeShort(serverHelloMessageV1_0.getVersion().getMajorVersion());
        outputStream.writeShort(serverHelloMessageV1_0.getVersion().getMinorVersion());
        Set<String> alternativeSigningProtocols = serverHelloMessageV1_0.getAlternativeSigningProtocols();
        outputStream.writeShort(alternativeSigningProtocols.size());
        for (String alternativeSigningProtocolName : alternativeSigningProtocols) {
            MyDataOutputStream.writeSmallUTF(alternativeSigningProtocolName, outputStream);
        }
    }

    @Override
    public ServerHelloMessage message(Signature signingProtocol, ProprietaryOrJCECipher cryptoProtocol, long idleTime, Version clientSiraPriseVersion, Set<String> alternativeSigningProtocols) {
        return new ServerHelloMessageV1_0(this, signingProtocol, cryptoProtocol, idleTime, clientSiraPriseVersion, alternativeSigningProtocols);
    }
}

