/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.CommunicationProtocolException;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.messages.ErrorMessageType;
import be.SIRAPRISE.messages.Messages;
import be.SIRAPRISE.messages.ServerErrorMessage;
import be.SIRAPRISE.messages.ServerMessageType;
import be.SIRAPRISE.messages.ServerMessageTypes;
import be.SIRAPRISE.security.ProprietaryOrJCECipher;
import be.SIRAPRISE.util.MyDataInputStream;
import be.erwinsmout.NotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public abstract class ServerMessage {
    private ServerMessageType type;

    public static ServerMessage readMessage(DataInputStream in, ProprietaryOrJCECipher cryptoProtocol, Signature signingProtocol, PublicKey publicKey) throws IOException, ErrorMessageException, CommunicationProtocolException {
        ServerMessageType serverMessageType;
        int byteCount = 0;
        byteCount = in.readInt();
        if (byteCount < 0) {
            throw new IOException(Messages.getString("ServerMessage.NegativeByteCount"));
        }
        byte[] inputBytes = MyDataInputStream.readExactNumberOfBytes(in, byteCount);
        if (cryptoProtocol != null) {
            try {
                inputBytes = cryptoProtocol.decrypt(inputBytes);
            }
            catch (InvalidKeyException e1) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.DecryptionFailed"), e1);
            }
            catch (IllegalBlockSizeException e1) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.DecryptionFailed"), e1);
            }
            catch (BadPaddingException e1) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.DecryptionFailed"), e1);
            }
        }
        DataInputStream localInputStream = new DataInputStream(new ByteArrayInputStream(inputBytes));
        if (signingProtocol != null) {
            try {
                short signatureLength = localInputStream.readShort();
                byte[] signature = new byte[signatureLength];
                localInputStream.read(signature);
                int actualMessageLength = localInputStream.readInt();
                byte[] actualMessage = MyDataInputStream.readExactNumberOfBytes(localInputStream, actualMessageLength);
                localInputStream = new DataInputStream(new ByteArrayInputStream(actualMessage));
                signingProtocol.initVerify(publicKey);
                signingProtocol.update(actualMessage);
                if (!signingProtocol.verify(signature)) {
                    throw new CommunicationProtocolException(Messages.getString("ServerMessage.VerificationFailed"), null);
                }
            }
            catch (InvalidKeyException e1) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.VerificationFailed"), e1);
            }
            catch (SignatureException e) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.VerificationFailed"), e);
            }
        }
        int messageType = localInputStream.readInt();
        int fullMessageVersion = localInputStream.readInt();
        try {
            serverMessageType = ServerMessageTypes.getInstance().getServerMessageTypeForMessageVersion(messageType, fullMessageVersion);
        }
        catch (NotFoundException notFoundException) {
            throw new CommunicationProtocolException(messageType, fullMessageVersion);
        }
        ServerMessage serverMessage = serverMessageType.typeSpecificFromStream(localInputStream);
        if (serverMessageType instanceof ErrorMessageType) {
            throw new ErrorMessageException((ServerErrorMessage)serverMessage);
        }
        return serverMessage;
    }

    ServerMessage(ServerMessageType type) {
        this.type = type;
    }

    public final int getMessageTypeID() {
        return this.type.getMessageTypeID();
    }

    public final void sendMessage(DataOutputStream out, Signature signingProtocol, Signer signer, ProprietaryOrJCECipher cryptoProtocol) throws IOException, CommunicationProtocolException {
        ByteArrayOutputStream byteArrayOutputStreamToBeWritten;
        ByteArrayOutputStream signedByteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.type.getMessageTypeID());
        dataOutputStream.writeShort(this.type.getMajorVersion());
        dataOutputStream.writeShort(this.type.getMinorVersion());
        this.type.typeSpecificToStream(this, dataOutputStream);
        if (signingProtocol != null) {
            signedByteArrayOutputStream = new ByteArrayOutputStream(byteArrayOutputStream.size());
            try {
                byte[] signMessage = byteArrayOutputStream.toByteArray();
                byte[] signature = signer.sign(signingProtocol, signMessage);
                DataOutputStream signedDataOutputStream = new DataOutputStream(signedByteArrayOutputStream);
                signedDataOutputStream.writeShort(signature.length);
                signedDataOutputStream.write(signature);
                signedDataOutputStream.writeInt(byteArrayOutputStream.size());
                signedDataOutputStream.write(signMessage);
            }
            catch (InvalidKeyException e) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.SigningFailed"), e);
            }
            catch (SignatureException e) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.SigningFailed"), e);
            }
            catch (NotFoundException e) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.SigningFailed"), e);
            }
        } else {
            signedByteArrayOutputStream = byteArrayOutputStream;
        }
        if (cryptoProtocol != null) {
            byteArrayOutputStreamToBeWritten = new ByteArrayOutputStream();
            try {
                byteArrayOutputStreamToBeWritten.write(cryptoProtocol.encrypt(signedByteArrayOutputStream.toByteArray()));
            }
            catch (InvalidKeyException e) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.EncryptionFailed"), e);
            }
            catch (IllegalBlockSizeException e) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.EncryptionFailed"), e);
            }
            catch (BadPaddingException e) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.EncryptionFailed"), e);
            }
        } else {
            byteArrayOutputStreamToBeWritten = signedByteArrayOutputStream;
        }
        out.writeInt(byteArrayOutputStreamToBeWritten.size());
        byteArrayOutputStreamToBeWritten.writeTo(out);
        out.flush();
    }
}

