/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.AuthenticationOKMessageTypeV1_0;
import be.SIRAPRISE.messages.ClientAuthenticationMessageTypeV1_0;
import be.SIRAPRISE.messages.ClientHelloMessageTypeV1_0;
import be.SIRAPRISE.messages.CommitRollbackMessageTypeV1_0;
import be.SIRAPRISE.messages.CommitRollbackMessageTypeV1_1;
import be.SIRAPRISE.messages.CommittedMessageTypeV1_0;
import be.SIRAPRISE.messages.ConstraintViolatedErrorMessageTypeV1_0;
import be.SIRAPRISE.messages.DmlExecutedMessageTypeV1_0;
import be.SIRAPRISE.messages.EndConnectionMessageTypeV1_0;
import be.SIRAPRISE.messages.EndTransactionMessageTypeV1_0;
import be.SIRAPRISE.messages.EndTransactionMessageTypeV1_1;
import be.SIRAPRISE.messages.ExecuteAssignmentMessageTypeV1_0;
import be.SIRAPRISE.messages.ExecuteDMLMessageTypeV1_0;
import be.SIRAPRISE.messages.ExecuteMonitorCommandMessageTypeV1_0;
import be.SIRAPRISE.messages.ExecuteQueryMessageTypeV1_0;
import be.SIRAPRISE.messages.NonSiraPriseErrorMessageTypeV1_0;
import be.SIRAPRISE.messages.NonSiraPriseErrorMessageTypeV1_1;
import be.SIRAPRISE.messages.ServerHelloMessageTypeV1_0;
import be.SIRAPRISE.messages.ServerMessageType;
import be.SIRAPRISE.messages.SiraPriseErrorMessageTypeV1_0;
import be.SIRAPRISE.messages.SiraPriseErrorMessageTypeV1_1;
import be.SIRAPRISE.messages.StartSubTransactionMessageTypeV1_0;
import be.SIRAPRISE.messages.StartTransactionMessageTypeV1_0;
import be.SIRAPRISE.messages.StartTransactionMessageTypeV1_1;
import be.SIRAPRISE.messages.StartTransactionMessageTypeV1_2;
import be.SIRAPRISE.messages.TransactionEndedMessageTypeV1_0;
import be.SIRAPRISE.messages.TransactionStartedMessageTypeV1_0;
import be.SIRAPRISE.messages.TransactionStartedMessageTypeV1_1;
import be.erwinsmout.NotFoundException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class ServerMessageTypes {
    private static final ServerMessageTypes instance = new ServerMessageTypes();
    private TreeMap<Long, ServerMessageType> serverMessageTypes = new TreeMap();
    private Version thisPackagesSiraPriseVersion;
    public static final int AUTHENTICATIONOK = 135352576;

    public static ServerMessageTypes getInstance() {
        return instance;
    }

    private ServerMessageTypes() {
        this.addServerMessageType(ConstraintViolatedErrorMessageTypeV1_0.getInstance());
        this.addServerMessageType(NonSiraPriseErrorMessageTypeV1_0.getInstance());
        this.addServerMessageType(NonSiraPriseErrorMessageTypeV1_1.getInstance());
        this.addServerMessageType(SiraPriseErrorMessageTypeV1_0.getInstance());
        this.addServerMessageType(SiraPriseErrorMessageTypeV1_1.getInstance());
        this.addServerMessageType(ClientAuthenticationMessageTypeV1_0.getInstance());
        this.addServerMessageType(ClientHelloMessageTypeV1_0.getInstance());
        this.addServerMessageType(CommitRollbackMessageTypeV1_0.getInstance());
        this.addServerMessageType(CommitRollbackMessageTypeV1_1.getInstance());
        this.addServerMessageType(EndConnectionMessageTypeV1_0.getInstance());
        this.addServerMessageType(EndTransactionMessageTypeV1_0.getInstance());
        this.addServerMessageType(EndTransactionMessageTypeV1_1.getInstance());
        this.addServerMessageType(ExecuteDMLMessageTypeV1_0.getInstance());
        this.addServerMessageType(ExecuteAssignmentMessageTypeV1_0.getInstance());
        this.addServerMessageType(ExecuteQueryMessageTypeV1_0.getInstance());
        this.addServerMessageType(ExecuteMonitorCommandMessageTypeV1_0.getInstance());
        this.addServerMessageType(StartSubTransactionMessageTypeV1_0.getInstance());
        this.addServerMessageType(StartTransactionMessageTypeV1_0.getInstance());
        this.addServerMessageType(StartTransactionMessageTypeV1_1.getInstance());
        this.addServerMessageType(StartTransactionMessageTypeV1_2.getInstance());
        this.addServerMessageType(AuthenticationOKMessageTypeV1_0.getInstance());
        this.addServerMessageType(CommittedMessageTypeV1_0.getInstance());
        this.addServerMessageType(DmlExecutedMessageTypeV1_0.getInstance());
        this.addServerMessageType(ServerHelloMessageTypeV1_0.getInstance());
        this.addServerMessageType(TransactionEndedMessageTypeV1_0.getInstance());
        this.addServerMessageType(TransactionStartedMessageTypeV1_0.getInstance());
        this.addServerMessageType(TransactionStartedMessageTypeV1_1.getInstance());
        this.thisPackagesSiraPriseVersion = new Version(1, 4);
    }

    private void addServerMessageType(ServerMessageType serverMessageType) {
        this.serverMessageTypes.put(new Long((long)serverMessageType.getMessageTypeID() << 32 | (long)serverMessageType.getMessageVersion().getFullVersion()), serverMessageType);
    }

    public ServerMessageType getServerMessageType(int messageType) throws NotFoundException {
        return this.getServerMessageTypeForSiraPriseVersion(messageType, this.thisPackagesSiraPriseVersion);
    }

    public ServerMessageType getServerMessageTypeForMessageVersion(int messageType, int messageVersion) throws NotFoundException {
        Long key = new Long((long)messageType << 32 | (long)messageVersion);
        if (this.serverMessageTypes.containsKey(key)) {
            return this.serverMessageTypes.get(key);
        }
        throw new NotFoundException();
    }

    public ServerMessageType getServerMessageTypeForSiraPriseVersion(int messageType, Version siraPriseVersion) throws NotFoundException {
        Long lowest = new Long((long)messageType << 32);
        Long highest = new Long((long)messageType << 32 | 0xFFFFFFFFL);
        SortedMap<Long, ServerMessageType> messageTypeVersions = this.serverMessageTypes.subMap(lowest, highest);
        Iterator<ServerMessageType> i_messageTypeVersions = messageTypeVersions.values().iterator();
        ServerMessageType returnServerMessageType = null;
        boolean moreRecentPossible = true;
        while (i_messageTypeVersions.hasNext() && moreRecentPossible) {
            ServerMessageType serverMessageType = i_messageTypeVersions.next();
            if (serverMessageType.introducedInSiraPriseVersion().compareTo(siraPriseVersion) < 1) {
                returnServerMessageType = serverMessageType;
                continue;
            }
            moreRecentPossible = false;
        }
        if (returnServerMessageType == null) {
            throw new NotFoundException();
        }
        return returnServerMessageType;
    }

    public Version getThisPackagesSiraPriseVersion() {
        return this.thisPackagesSiraPriseVersion;
    }
}

