/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.SiraPriseErrorMessage;
import be.SIRAPRISE.messages.SiraPriseErrorMessageType;
import be.SIRAPRISE.messages.SiraPriseErrorMessageV1_0;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SiraPriseErrorMessageTypeV1_0
extends SiraPriseErrorMessageType {
    private static SiraPriseErrorMessageType instance = new SiraPriseErrorMessageTypeV1_0();
    private static final int MAXIMUMERRORMESSAGELENGTH = 8192;

    static SiraPriseErrorMessageType getInstance() {
        return instance;
    }

    private SiraPriseErrorMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        long siraPriseErrorNumber = in.readLong();
        String exceptionMessage = MyDataInputStream.getSmallUTFString(in);
        return new SiraPriseErrorMessageV1_0(siraPriseErrorNumber, exceptionMessage);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof SiraPriseErrorMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        SiraPriseErrorMessageV1_0 siraPriseErrorMessageV1_0 = (SiraPriseErrorMessageV1_0)message;
        outputStream.writeLong(siraPriseErrorMessageV1_0.getErrorNumber());
        MyDataOutputStream.writeSmallUTF(siraPriseErrorMessageV1_0.getOriginalExceptionMessage(), outputStream);
    }

    @Override
    public SiraPriseErrorMessage message(long errorNumber, String message, boolean fatal) {
        return new SiraPriseErrorMessageV1_0(errorNumber, message.substring(0, Math.min(message.length(), 8192)));
    }
}

