/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.SiraPriseErrorMessage;
import be.SIRAPRISE.messages.SiraPriseErrorMessageType;
import be.SIRAPRISE.messages.SiraPriseErrorMessageV1_1;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SiraPriseErrorMessageTypeV1_1
extends SiraPriseErrorMessageType {
    private static SiraPriseErrorMessageType instance = new SiraPriseErrorMessageTypeV1_1();
    private static final int MAXIMUMERRORMESSAGELENGTH = 8192;

    static SiraPriseErrorMessageType getInstance() {
        return instance;
    }

    private SiraPriseErrorMessageTypeV1_1() {
        super(Version.ONE_ONE, Version.ONE_FOUR);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        long siraPriseErrorNumber = in.readLong();
        String exceptionMessage = MyDataInputStream.getSmallUTFString(in);
        byte fatal = in.readByte();
        return new SiraPriseErrorMessageV1_1(siraPriseErrorNumber, exceptionMessage, fatal != 0);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof SiraPriseErrorMessageV1_1)) {
            throw new IllegalArgumentException();
        }
        SiraPriseErrorMessageV1_1 siraPriseErrorMessageV1_1 = (SiraPriseErrorMessageV1_1)message;
        outputStream.writeLong(siraPriseErrorMessageV1_1.getErrorNumber());
        MyDataOutputStream.writeSmallUTF(siraPriseErrorMessageV1_1.getOriginalExceptionMessage(), outputStream);
        outputStream.writeByte(siraPriseErrorMessageV1_1.isFatal() ? 1 : 0);
    }

    @Override
    public SiraPriseErrorMessage message(long errorNumber, String message, boolean fatal) {
        return new SiraPriseErrorMessageV1_1(errorNumber, message.substring(0, Math.min(message.length(), 8192)), fatal);
    }
}

