/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.Messages;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.StartTransactionMessage;
import be.SIRAPRISE.messages.StartTransactionMessageType;
import be.SIRAPRISE.messages.StartTransactionMessageV1_0;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StartTransactionMessageTypeV1_0
extends StartTransactionMessageType {
    private static StartTransactionMessageType instance = new StartTransactionMessageTypeV1_0();

    static StartTransactionMessageType getInstance() {
        return instance;
    }

    private StartTransactionMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        String userID = MyDataInputStream.getSmallUTFString(in);
        boolean authenticatedByClient = in.readByte() == 1;
        String userAuthenticationAlgorithm = MyDataInputStream.getSmallUTFString(in);
        short signatureLength = in.readShort();
        byte[] signature = new byte[signatureLength];
        in.read(signature);
        return new StartTransactionMessageV1_0(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof StartTransactionMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        StartTransactionMessageV1_0 startTransactionMessageMessageV1_0 = (StartTransactionMessageV1_0)message;
        MyDataOutputStream.writeSmallUTF(startTransactionMessageMessageV1_0.getUserID(), outputStream);
        outputStream.writeByte(startTransactionMessageMessageV1_0.isUserAuthenticatedByClient() ? 1 : 0);
        MyDataOutputStream.writeSmallUTF(startTransactionMessageMessageV1_0.getUserAuthenticationAlgorithm(), outputStream);
        byte[] signature = startTransactionMessageMessageV1_0.getSignature();
        outputStream.writeShort(signature.length);
        outputStream.write(signature);
    }

    @Override
    public StartTransactionMessage message(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean readOnlyTransaction, boolean autoCommit, DDLCapture captureDDL) {
        if (readOnlyTransaction || autoCommit || captureDDL.isCapturingDDL()) {
            throw new IllegalArgumentException(Messages.getString("StartTransactionMessageTypeV1_0.IncompatibleWithServer"));
        }
        return new StartTransactionMessageV1_0(this, userID, userAuthenticatedByClient, signatureAlgorithm, signature);
    }
}

