/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.Messages;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.StartTransactionMessage;
import be.SIRAPRISE.messages.StartTransactionMessageType;
import be.SIRAPRISE.messages.StartTransactionMessageV1_1;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StartTransactionMessageTypeV1_1
extends StartTransactionMessageType {
    private static StartTransactionMessageType instance = new StartTransactionMessageTypeV1_1();

    static StartTransactionMessageType getInstance() {
        return instance;
    }

    private StartTransactionMessageTypeV1_1() {
        super(Version.ONE_ONE, Version.ONE_TWO);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        String userID = MyDataInputStream.getSmallUTFString(in);
        boolean authenticatedByClient = in.readByte() == 1;
        String userAuthenticationAlgorithm = MyDataInputStream.getSmallUTFString(in);
        short signatureLength = in.readShort();
        byte[] signature = new byte[signatureLength];
        in.read(signature);
        boolean readOnlyTransaction = in.readByte() == 1;
        boolean transactionWithStatementLevelLockRelease = in.readByte() == 1;
        return new StartTransactionMessageV1_1(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature, readOnlyTransaction, transactionWithStatementLevelLockRelease);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof StartTransactionMessageV1_1)) {
            throw new IllegalArgumentException();
        }
        StartTransactionMessageV1_1 startTransactionMessageV1_1 = (StartTransactionMessageV1_1)message;
        MyDataOutputStream.writeSmallUTF(startTransactionMessageV1_1.getUserID(), outputStream);
        outputStream.writeByte(startTransactionMessageV1_1.isUserAuthenticatedByClient() ? 1 : 0);
        MyDataOutputStream.writeSmallUTF(startTransactionMessageV1_1.getUserAuthenticationAlgorithm(), outputStream);
        byte[] signature = startTransactionMessageV1_1.getSignature();
        outputStream.writeShort(signature.length);
        outputStream.write(signature);
        outputStream.writeByte(startTransactionMessageV1_1.isReadOnlyTransaction() ? 1 : 0);
        outputStream.writeByte(startTransactionMessageV1_1.isAutoCommit() ? 1 : 0);
    }

    @Override
    public StartTransactionMessage message(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean readOnlyTransaction, boolean autoCommit, DDLCapture captureDDL) {
        if (captureDDL.isCapturingDDL()) {
            throw new IllegalArgumentException(Messages.getString("StartTransactionMessageTypeV1_1.IncompatibleWithServer"));
        }
        return new StartTransactionMessageV1_1(this, userID, userAuthenticatedByClient, signatureAlgorithm, signature, readOnlyTransaction, autoCommit);
    }
}

