/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.StartTransactionMessage;
import be.SIRAPRISE.messages.StartTransactionMessageType;
import be.SIRAPRISE.messages.StartTransactionMessageV1_2;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StartTransactionMessageTypeV1_2
extends StartTransactionMessageType {
    private static StartTransactionMessageType instance = new StartTransactionMessageTypeV1_2();

    static StartTransactionMessageType getInstance() {
        return instance;
    }

    private StartTransactionMessageTypeV1_2() {
        super(Version.ONE_TWO, Version.ONE_THREE);
    }

    @Override
    ServerMessage typeSpecificFromStream(DataInputStream in) throws IOException {
        String userID = MyDataInputStream.getSmallUTFString(in);
        boolean authenticatedByClient = in.readByte() == 1;
        String userAuthenticationAlgorithm = MyDataInputStream.getSmallUTFString(in);
        short signatureLength = in.readShort();
        byte[] signature = new byte[signatureLength];
        in.read(signature);
        boolean readOnlyTransaction = in.readByte() == 1;
        boolean transactionWithStatementLevelLockRelease = in.readByte() == 1;
        boolean captureDDL = in.readByte() == 1;
        return new StartTransactionMessageV1_2(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature, readOnlyTransaction, transactionWithStatementLevelLockRelease, captureDDL);
    }

    @Override
    void typeSpecificToStream(ServerMessage message, DataOutputStream outputStream) throws IOException {
        if (!(message instanceof StartTransactionMessageV1_2)) {
            throw new IllegalArgumentException();
        }
        StartTransactionMessageV1_2 startTransactionMessageV1_2 = (StartTransactionMessageV1_2)message;
        MyDataOutputStream.writeSmallUTF(startTransactionMessageV1_2.getUserID(), outputStream);
        outputStream.writeByte(startTransactionMessageV1_2.isUserAuthenticatedByClient() ? 1 : 0);
        MyDataOutputStream.writeSmallUTF(startTransactionMessageV1_2.getUserAuthenticationAlgorithm(), outputStream);
        byte[] signature = startTransactionMessageV1_2.getSignature();
        outputStream.writeShort(signature.length);
        outputStream.write(signature);
        outputStream.writeByte(startTransactionMessageV1_2.isReadOnlyTransaction() ? 1 : 0);
        outputStream.writeByte(startTransactionMessageV1_2.isAutoCommit() ? 1 : 0);
        outputStream.writeByte(startTransactionMessageV1_2.isCaptureDDL() ? 1 : 0);
    }

    @Override
    public StartTransactionMessage message(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean readOnlyTransaction, boolean autoCommit, DDLCapture captureDDL) {
        return new StartTransactionMessageV1_2(this, userID, userAuthenticatedByClient, signatureAlgorithm, signature, readOnlyTransaction, autoCommit, captureDDL.isCapturingDDL());
    }
}

