/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.util.BracketParseResult;
import be.SIRAPRISE.util.DuplicateNameException;
import be.SIRAPRISE.util.IntersectableHashMap;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NameValuePair;
import be.SIRAPRISE.util.NameValueResult;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class BracketParser {
    private static boolean hasUnneededOutermostBrackets(String s) {
        if (s.startsWith("(") && s.endsWith(")")) {
            try {
                return BracketParser.findCorrespondingClosingBracket(s) == s.length() - 1;
            }
            catch (NoClosingBracketException noClosingBracketException) {
                return false;
            }
        }
        return false;
    }

    public static LinkedList<String> createListFromEscaped(String s) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, NoOpeningBracketException {
        LinkedList<String> list = new LinkedList<String>();
        int p = 0;
        while (p < s.length()) {
            NameValueResult result = BracketParser.getNameAndMandatoryValueFromEscaped(s, p);
            NameValuePair nameValuePair = result.getNameValuePair();
            String valuePart = nameValuePair.getValue();
            list.add(valuePart);
            p = result.getNextParsePos();
        }
        return list;
    }

    public static LinkedList<String> createListFromNonEscaped(String s) throws NoClosingBracketException, NoOpeningBracketException {
        LinkedList<String> list = new LinkedList<String>();
        int p = 0;
        while (p < s.length()) {
            NameValueResult result = BracketParser.getNameAndMandatoryValueFromNonEscaped(s, p);
            NameValuePair nameValuePair = result.getNameValuePair();
            String valuePart = nameValuePair.getValue();
            list.add(valuePart);
            p = result.getNextParsePos();
        }
        return list;
    }

    public static HashMap<String, String> createMapFromEscaped(String s) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, DuplicateNameException {
        HashMap<String, String> attributeValueMap = new HashMap<String, String>();
        int p = 0;
        while (p < s.length()) {
            NameValueResult result = BracketParser.getNameValueFromEscaped(s, p);
            NameValuePair nameValuePair = result.getNameValuePair();
            String namePart = nameValuePair.getName();
            String valuePart = nameValuePair.getValue();
            if (attributeValueMap.containsKey(namePart)) {
                throw new DuplicateNameException(namePart);
            }
            attributeValueMap.put(namePart, valuePart);
            p = result.getNextParsePos();
        }
        return attributeValueMap;
    }

    public static HashMap<String, String> createMapFromNonEscaped(String s) throws NoClosingBracketException, DuplicateNameException {
        HashMap<String, String> attributeValueMap = new HashMap<String, String>();
        int p = 0;
        while (p < s.length()) {
            NameValueResult result = BracketParser.getNameValueFromNonEscaped(s, p);
            NameValuePair nameValuePair = result.getNameValuePair();
            String namePart = nameValuePair.getName();
            String valuePart = nameValuePair.getValue();
            if (attributeValueMap.containsKey(namePart)) {
                throw new DuplicateNameException(namePart);
            }
            attributeValueMap.put(namePart, valuePart);
            p = result.getNextParsePos();
        }
        return attributeValueMap;
    }

    public static HashMap<String, String> createMapWithMandatoryValuesFromEscaped(String s) throws DuplicateNameException, NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, NoOpeningBracketException {
        HashMap<String, String> attributeValueMap = new HashMap<String, String>();
        BracketParser.fillMapWithMandatoryValuesFromEscaped(s, attributeValueMap);
        return attributeValueMap;
    }

    public static HashMap<String, String> createMapWithMandatoryValuesFromNonEscaped(String s) throws DuplicateNameException, NoClosingBracketException, NoOpeningBracketException {
        HashMap<String, String> attributeValueMap = new HashMap<String, String>();
        BracketParser.fillMapWithMandatoryValuesFromNonEscaped(s, attributeValueMap);
        return attributeValueMap;
    }

    public static void fillMapWithMandatoryValuesFromEscaped(String s, Map<String, String> attributeValueMap) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, NoOpeningBracketException, DuplicateNameException {
        int p = 0;
        while (p < s.length()) {
            NameValueResult result = BracketParser.getNameAndMandatoryValueFromEscaped(s, p);
            NameValuePair nameValuePair = result.getNameValuePair();
            String namePart = nameValuePair.getName();
            String valuePart = nameValuePair.getValue();
            if (attributeValueMap.containsKey(namePart)) {
                throw new DuplicateNameException(namePart);
            }
            attributeValueMap.put(namePart, valuePart);
            p = result.getNextParsePos();
        }
    }

    public static void fillMapWithMandatoryValuesFromNonEscaped(String s, Map<String, String> attributeValueMap) throws NoClosingBracketException, NoOpeningBracketException, DuplicateNameException {
        int p = 0;
        while (p < s.length()) {
            NameValueResult result = BracketParser.getNameAndMandatoryValueFromNonEscaped(s, p);
            NameValuePair nameValuePair = result.getNameValuePair();
            String namePart = nameValuePair.getName();
            String valuePart = nameValuePair.getValue();
            if (attributeValueMap.containsKey(namePart)) {
                throw new DuplicateNameException(namePart);
            }
            attributeValueMap.put(namePart, valuePart);
            p = result.getNextParsePos();
        }
    }

    public static void fillNonEmptyMapWithMandatoryValuesFromEscaped(String s, Map<String, String> attributeValueMap) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, NoOpeningBracketException, DuplicateNameException {
        BracketParser.fillMapWithMandatoryValuesFromEscaped(s, attributeValueMap);
        if (attributeValueMap.size() < 1) {
            throw new IllegalArgumentException("Empty map not allowed from " + s);
        }
    }

    public static void fillNonEmptyMapWithMandatoryValuesFromNonEscaped(String s, Map<String, String> attributeValueMap) throws NoClosingBracketException, NoOpeningBracketException, DuplicateNameException {
        BracketParser.fillMapWithMandatoryValuesFromNonEscaped(s, attributeValueMap);
        if (attributeValueMap.size() < 1) {
            throw new IllegalArgumentException("Empty map not allowed from " + s);
        }
    }

    public static int findCorrespondingClosingBracket(String s) throws NoClosingBracketException {
        int p1 = 0;
        int l = 0;
        boolean escapeFromMeta = false;
        do {
            char c = s.charAt(p1);
            if (escapeFromMeta) {
                escapeFromMeta = false;
                continue;
            }
            if (c == '\\') {
                escapeFromMeta = true;
                continue;
            }
            if (c == '(') {
                ++l;
                continue;
            }
            if (c != ')') continue;
            --l;
        } while (l != 0 && ++p1 < s.length());
        if (p1 == 0 || l != 0) {
            throw new NoClosingBracketException(s);
        }
        return p1;
    }

    public static NameValueResult getNameAndMandatoryValueFromEscaped(String s, int startPos) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, NoOpeningBracketException {
        int checkPos = Math.max(0, startPos);
        int slength = s.length();
        boolean escapeFromMeta = false;
        boolean inspect = true;
        block15: while (checkPos < slength && inspect) {
            if (escapeFromMeta) {
                switch (s.charAt(checkPos)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        escapeFromMeta = false;
                        ++checkPos;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                    }
                }
            }
            switch (s.charAt(checkPos)) {
                case '(': {
                    inspect = false;
                    break;
                }
                case '\\': {
                    escapeFromMeta = true;
                    ++checkPos;
                    break;
                }
                default: {
                    ++checkPos;
                }
            }
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (inspect) {
            throw new NoOpeningBracketException(s.substring(startPos));
        }
        String namePart = s.substring(startPos, checkPos).trim();
        inspect = true;
        int level = 1;
        int openingBracketPos = ++checkPos;
        while (level > 0 && checkPos < slength) {
            block23: {
                block22: {
                    if (!escapeFromMeta) break block22;
                    switch (s.charAt(checkPos)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            escapeFromMeta = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                        }
                    }
                }
                switch (s.charAt(checkPos)) {
                    case ')': {
                        --level;
                        break;
                    }
                    case '(': {
                        ++level;
                        break;
                    }
                    case '\\': {
                        escapeFromMeta = true;
                    }
                }
            }
            ++checkPos;
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (level > 0) {
            throw new NoClosingBracketException(s.substring(startPos));
        }
        return new NameValueResult(startPos, --checkPos, new NameValuePair(namePart, s.substring(openingBracketPos, checkPos)));
    }

    public static NameValueResult getNameAndMandatoryValueFromNonEscaped(String s, int startPos) throws NoClosingBracketException, NoOpeningBracketException {
        int checkPos = Math.max(0, startPos);
        int slength = s.length();
        boolean inspect = true;
        while (checkPos < slength && inspect) {
            switch (s.charAt(checkPos)) {
                case '(': {
                    inspect = false;
                    break;
                }
                default: {
                    ++checkPos;
                }
            }
        }
        if (inspect) {
            throw new NoOpeningBracketException(s.substring(startPos));
        }
        String namePart = s.substring(startPos, checkPos).trim();
        inspect = true;
        int level = 1;
        int openingBracketPos = ++checkPos;
        while (level > 0 && checkPos < slength) {
            switch (s.charAt(checkPos)) {
                case ')': {
                    --level;
                    break;
                }
                case '(': {
                    ++level;
                }
            }
            ++checkPos;
        }
        if (level > 0) {
            throw new NoClosingBracketException(s.substring(startPos));
        }
        return new NameValueResult(startPos, --checkPos, new NameValuePair(namePart, s.substring(openingBracketPos, checkPos)));
    }

    public static NameValueResult getNameAndMandatoryValueUntrimmedFromEscaped(String s, int startPos) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, NoOpeningBracketException {
        int bracketPos = 0;
        int checkPos = Math.max(0, startPos);
        int slength = s.length();
        boolean escapeFromMeta = false;
        boolean inspect = true;
        block15: while (checkPos < slength && inspect) {
            if (escapeFromMeta) {
                switch (s.charAt(checkPos)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        escapeFromMeta = false;
                        ++checkPos;
                        ++bracketPos;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                    }
                }
            }
            switch (s.charAt(checkPos)) {
                case '(': {
                    inspect = false;
                    break;
                }
                case '\\': {
                    escapeFromMeta = true;
                    ++checkPos;
                    ++bracketPos;
                    break;
                }
                default: {
                    ++checkPos;
                    ++bracketPos;
                }
            }
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (inspect) {
            throw new NoOpeningBracketException(s.substring(startPos));
        }
        String namePart = s.substring(startPos, checkPos).trim();
        inspect = true;
        int level = 1;
        ++checkPos;
        int openingBracketPos = ++bracketPos;
        while (level > 0 && checkPos < slength) {
            block23: {
                block22: {
                    if (!escapeFromMeta) break block22;
                    switch (s.charAt(checkPos)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            escapeFromMeta = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                        }
                    }
                }
                switch (s.charAt(checkPos)) {
                    case ')': {
                        --level;
                        break;
                    }
                    case '(': {
                        ++level;
                        break;
                    }
                    case '\\': {
                        escapeFromMeta = true;
                    }
                }
            }
            ++checkPos;
            ++bracketPos;
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (level > 0) {
            throw new NoClosingBracketException(s.substring(startPos));
        }
        --bracketPos;
        return new NameValueResult(startPos, --checkPos, new NameValuePair(namePart, s.substring(openingBracketPos, checkPos)));
    }

    public static BracketParseResult getNameBeforeBracket(String s) throws NoOpeningBracketException {
        int bracketpos = s.indexOf(40);
        if (bracketpos < 0) {
            throw new NoOpeningBracketException(s);
        }
        return new BracketParseResult(s.substring(0, bracketpos).trim().toUpperCase(), bracketpos);
    }

    public static NameValueResult getNameValueFromEscaped(String s, int startPos) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException {
        int checkPos = Math.max(0, startPos);
        int slength = s.length();
        boolean escapeFromMeta = false;
        boolean inspect = true;
        block15: while (checkPos < slength && inspect) {
            if (escapeFromMeta) {
                switch (s.charAt(checkPos)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        escapeFromMeta = false;
                        ++checkPos;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                    }
                }
            }
            switch (s.charAt(checkPos)) {
                case '(': {
                    inspect = false;
                    break;
                }
                case '\\': {
                    escapeFromMeta = true;
                    ++checkPos;
                    break;
                }
                default: {
                    ++checkPos;
                }
            }
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (inspect) {
            String namePart = s.substring(startPos).trim();
            return new NameValueResult(startPos, checkPos, new NameValuePair(namePart, ""));
        }
        String namePart = s.substring(startPos, checkPos).trim();
        inspect = true;
        int level = 1;
        int openingBracketPos = ++checkPos;
        while (level > 0 && checkPos < slength) {
            block23: {
                block22: {
                    if (!escapeFromMeta) break block22;
                    switch (s.charAt(checkPos)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            escapeFromMeta = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                        }
                    }
                }
                switch (s.charAt(checkPos)) {
                    case ')': {
                        --level;
                        break;
                    }
                    case '(': {
                        ++level;
                        break;
                    }
                    case '\\': {
                        escapeFromMeta = true;
                    }
                }
            }
            ++checkPos;
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (level > 0) {
            throw new NoClosingBracketException(s.substring(startPos));
        }
        return new NameValueResult(startPos, --checkPos, new NameValuePair(new String(namePart), s.substring(openingBracketPos, checkPos).trim()));
    }

    public static NameValueResult getNameValueFromNonEscaped(String s, int startPos) throws NoClosingBracketException {
        int checkPos = Math.max(0, startPos);
        int slength = s.length();
        boolean inspect = true;
        while (checkPos < slength && inspect) {
            switch (s.charAt(checkPos)) {
                case '(': {
                    inspect = false;
                    break;
                }
                default: {
                    ++checkPos;
                }
            }
        }
        if (inspect) {
            String namePart = s.substring(startPos).trim();
            return new NameValueResult(startPos, checkPos, new NameValuePair(namePart, ""));
        }
        String namePart = s.substring(startPos, checkPos).trim();
        inspect = true;
        int level = 1;
        int openingBracketPos = ++checkPos;
        while (level > 0 && checkPos < slength) {
            switch (s.charAt(checkPos)) {
                case ')': {
                    --level;
                    break;
                }
                case '(': {
                    ++level;
                }
            }
            ++checkPos;
        }
        if (level > 0) {
            throw new NoClosingBracketException(s.substring(startPos));
        }
        return new NameValueResult(startPos, --checkPos, new NameValuePair(namePart, s.substring(openingBracketPos, checkPos).trim()));
    }

    public static NameValueResult getNameValueUntrimmedFromEscaped(String s, int startPos) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException {
        int checkPos = Math.max(0, startPos);
        int slength = s.length();
        boolean escapeFromMeta = false;
        boolean inspect = true;
        block15: while (checkPos < slength && inspect) {
            if (escapeFromMeta) {
                switch (s.charAt(checkPos)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        escapeFromMeta = false;
                        ++checkPos;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                    }
                }
            }
            switch (s.charAt(checkPos)) {
                case '(': {
                    inspect = false;
                    break;
                }
                case '\\': {
                    escapeFromMeta = true;
                    ++checkPos;
                    break;
                }
                default: {
                    ++checkPos;
                }
            }
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (inspect) {
            String namePart = s.substring(startPos).trim();
            return new NameValueResult(startPos, checkPos, new NameValuePair(namePart, ""));
        }
        String namePart = s.substring(startPos, checkPos).trim();
        inspect = true;
        int level = 1;
        int openingBracketPos = ++checkPos;
        while (level > 0 && checkPos < slength) {
            block23: {
                block22: {
                    if (!escapeFromMeta) break block22;
                    switch (s.charAt(checkPos)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            escapeFromMeta = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(checkPos, s.charAt(checkPos));
                        }
                    }
                }
                switch (s.charAt(checkPos)) {
                    case ')': {
                        --level;
                        break;
                    }
                    case '(': {
                        ++level;
                        break;
                    }
                    case '\\': {
                        escapeFromMeta = true;
                    }
                }
            }
            ++checkPos;
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        if (level > 0) {
            throw new NoClosingBracketException(s.substring(startPos));
        }
        return new NameValueResult(startPos, --checkPos, new NameValuePair(namePart, s.substring(openingBracketPos, checkPos)));
    }

    public static BracketParseResult getUnMetaContentsWithinBrackets(String s) throws NoOpeningBracketException, NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException {
        int openBracketPos = s.indexOf(40);
        if (openBracketPos == -1) {
            throw new NoOpeningBracketException(s);
        }
        String s2 = s.substring(openBracketPos);
        int closingbracketpos = BracketParser.findCorrespondingClosingBracket(s2);
        String s3 = s2.substring(1, closingbracketpos).trim();
        return new BracketParseResult(BracketParser.unMeta(s3), openBracketPos + closingbracketpos + 1);
    }

    public static BracketParseResult getUnMetaContentsWithinBracketsUntrimmed(String s) throws NoOpeningBracketException, NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException {
        int openBracketPos = s.indexOf(40);
        if (openBracketPos == -1) {
            throw new NoOpeningBracketException(s);
        }
        String s2 = s.substring(openBracketPos);
        int closingbracketpos = BracketParser.findCorrespondingClosingBracket(s2);
        String s3 = s2.substring(1, closingbracketpos);
        return new BracketParseResult(BracketParser.unMeta(s3), openBracketPos + closingbracketpos + 1);
    }

    public static String meta(String s) {
        int slength = s.length();
        StringBuffer w = new StringBuffer(slength + (slength >>> 3));
        int i = 0;
        while (i < slength) {
            char c = s.charAt(i++);
            switch (c) {
                case '(': {
                    w.append("\\(");
                    break;
                }
                case ')': {
                    w.append("\\)");
                    break;
                }
                case '\\': {
                    w.append("\\\\");
                    break;
                }
                default: {
                    w.append(c);
                }
            }
        }
        return w.toString();
    }

    public static String removeSuperfluousOuterBrackets(String arg) {
        String wrk = arg;
        while (BracketParser.hasUnneededOutermostBrackets(wrk)) {
            wrk = wrk.substring(1, wrk.length() - 1).trim();
        }
        return wrk;
    }

    public static String unMeta(String s) throws InvalidEscapedCharacterException, MissingEscapedCharacterException {
        int slength = s.length();
        StringBuffer w = new StringBuffer(slength);
        int i = 0;
        boolean escapeFromMeta = false;
        block6: while (i < slength) {
            char c = s.charAt(i++);
            if (escapeFromMeta) {
                switch (c) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        w.append(c);
                        escapeFromMeta = false;
                        continue block6;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(i, s.charAt(i));
                    }
                }
            }
            switch (c) {
                case '\\': {
                    escapeFromMeta = true;
                    break;
                }
                default: {
                    w.append(c);
                }
            }
        }
        if (escapeFromMeta) {
            throw new MissingEscapedCharacterException();
        }
        return w.toString();
    }

    public static String unMetaWithoutException(String s) {
        try {
            return BracketParser.unMeta(s);
        }
        catch (InvalidEscapedCharacterException e) {
            throw new IllegalArgumentException(String.valueOf(s) + ":\n" + e.getMessage());
        }
        catch (MissingEscapedCharacterException missingEscapedCharacterException) {
            throw new IllegalArgumentException(s);
        }
    }

    public static Map<String, String> createMapFromEscapedString(String s, boolean emptyMapAllowed) throws NoClosingBracketException, InvalidEscapedCharacterException, MissingEscapedCharacterException, NoOpeningBracketException, DuplicateNameException {
        IntersectableHashMap<String, String> attributeValueMap = new IntersectableHashMap<String, String>();
        if (emptyMapAllowed) {
            BracketParser.fillMapWithMandatoryValuesFromEscaped(s, attributeValueMap);
        } else {
            BracketParser.fillNonEmptyMapWithMandatoryValuesFromEscaped(s, attributeValueMap);
        }
        return attributeValueMap;
    }
}

