/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class CRLFInputStream
extends InputStream {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private InputStream in;
    private boolean skipByteIfLF;

    public CRLFInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public String readLine(Charset charSet) throws IOException {
        int capacity = 2048;
        byte[] buffer = new byte[capacity];
        boolean proceed = true;
        boolean anyByteRead = false;
        int byteCount = 0;
        while (proceed) {
            byte b = (byte)this.in.read();
            switch (b) {
                case -1: {
                    proceed = false;
                    break;
                }
                case 13: {
                    proceed = false;
                    anyByteRead = true;
                    this.skipByteIfLF = true;
                    break;
                }
                case 10: {
                    if (!this.skipByteIfLF) {
                        proceed = false;
                        anyByteRead = true;
                    }
                    this.skipByteIfLF = false;
                    break;
                }
                default: {
                    this.skipByteIfLF = false;
                    anyByteRead = true;
                    if (byteCount == capacity) {
                        if ((capacity & 0x40000000) == 0) {
                            byte[] newbuffer = new byte[capacity <<= 1];
                            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                            buffer = newbuffer;
                        } else {
                            throw new OutOfMemoryError();
                        }
                    }
                    buffer[byteCount] = b;
                    ++byteCount;
                }
            }
        }
        if (!anyByteRead) {
            throw new EOFException();
        }
        return new String(buffer, 0, byteCount, charSet);
    }
}

