/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.NameValuePair;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.erwinsmout.MyProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CommandLineParameters
extends Properties {
    private static final long serialVersionUID = 3300117546127188106L;

    private static HashMap<String, String> getCommandLineParameters(String[] args, String defaultPropertyName) {
        HashMap<String, String> commandLineParametersMap = new HashMap<String, String>();
        int i = 0;
        int argc = args.length;
        while (i < argc) {
            String arg = args[i];
            try {
                NameValuePair nameValuePair = BracketParser.getNameAndMandatoryValueFromNonEscaped(arg, 0).getNameValuePair();
                String argumentName = nameValuePair.getName();
                String argumentValue = nameValuePair.getValue();
                if (argumentValue.length() < 1) {
                    if (defaultPropertyName == null) {
                        throw new IllegalArgumentException(arg);
                    }
                    commandLineParametersMap.put(defaultPropertyName.toUpperCase(), MyProperties.resolveSystemPropertyRefs(arg));
                } else {
                    commandLineParametersMap.put(argumentName, MyProperties.resolveSystemPropertyRefs(argumentValue));
                }
            }
            catch (NoClosingBracketException noClosingBracketException) {
                throw new IllegalArgumentException(arg);
            }
            catch (NoOpeningBracketException noOpeningBracketException) {
                if (arg.charAt(0) == '-') {
                    int c = (arg = arg.substring(1)).indexOf(58);
                    if (c < 1) {
                        throw new IllegalArgumentException(arg);
                    }
                    commandLineParametersMap.put(arg.substring(0, c).toUpperCase(), MyProperties.resolveSystemPropertyRefs(arg.substring(c + 1)));
                }
                if (defaultPropertyName == null) {
                    throw new IllegalArgumentException(arg);
                }
                commandLineParametersMap.put(defaultPropertyName.toUpperCase(), MyProperties.resolveSystemPropertyRefs(arg));
            }
            ++i;
        }
        return commandLineParametersMap;
    }

    public static CommandLineParameters getCommandLineParameters(String[] args, String defaultPropertyName, Properties defaultProperties) {
        CommandLineParameters commandLineProperties = new CommandLineParameters(defaultProperties);
        for (Map.Entry<String, String> entry : CommandLineParameters.getCommandLineParameters(args, defaultPropertyName).entrySet()) {
            commandLineProperties.setProperty(entry.getKey(), entry.getValue());
        }
        return commandLineProperties;
    }

    private CommandLineParameters(Properties defaultProperties) {
        super(defaultProperties);
    }
}

