/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.util.EqualKeyUnequalValuesException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class IntersectableMap<K, V>
implements Map<K, V> {
    abstract Map<K, V> getMap();

    abstract Map<K, V> getMapClone();

    abstract void setMap(Map<K, V> var1);

    @Override
    public final void clear() {
        this.getMap().clear();
    }

    public final Object clone() {
        IntersectableMap newIntersectableMap = null;
        try {
            newIntersectableMap = (IntersectableMap)super.clone();
            newIntersectableMap.setMap(this.getMapClone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return newIntersectableMap;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof IntersectableMap ? this.getMap().equals(((IntersectableMap)obj).getMap()) : this.getMap().equals(obj);
    }

    @Override
    public final V get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public final int hashCode() {
        return this.getMap().hashCode();
    }

    public final IntersectableMap<K, V> intersect(Set<?> keys) {
        IntersectableMap<K, V> intersect = this.getClone();
        Iterator<K> i = intersect.keySet().iterator();
        while (i.hasNext()) {
            K k = i.next();
            if (keys.contains(k)) continue;
            i.remove();
        }
        return intersect;
    }

    protected abstract IntersectableMap<K, V> getClone();

    public final Map<K, V> intersect(Set<?> keys, Class<? extends Map<K, V>> resultClass) throws InstantiationException, IllegalAccessException {
        if (!Map.class.isAssignableFrom(resultClass)) {
            throw new IllegalArgumentException();
        }
        Map<Object, V> intersect = resultClass.newInstance();
        if (this.size() < keys.size()) {
            for (Map.Entry<K, V> me : this.entrySet()) {
                K k = me.getKey();
                if (!keys.contains(k)) continue;
                intersect.put(k, me.getValue());
            }
        } else {
            for (Object k : keys) {
                if (!this.containsKey(k)) continue;
                intersect.put(k, this.get(k));
            }
        }
        return intersect;
    }

    @Override
    public final boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public final Set<K> keySet() {
        return this.getMap().keySet();
    }

    public final IntersectableMap<K, V> minus(Set<?> keys) {
        IntersectableMap<K, V> minus = this.getClone();
        Iterator<K> i = minus.keySet().iterator();
        while (i.hasNext()) {
            K k = i.next();
            if (!keys.contains(k)) continue;
            i.remove();
        }
        return minus;
    }

    public final Map<K, V> minus(Set<?> keys, Class<? extends Map<K, V>> resultClass) throws InstantiationException, IllegalAccessException {
        if (!Map.class.isAssignableFrom(resultClass)) {
            throw new IllegalArgumentException();
        }
        Map<K, V> minus = resultClass.newInstance();
        if (this.size() < 3 * keys.size()) {
            for (Map.Entry<K, V> me : this.entrySet()) {
                K k = me.getKey();
                if (keys.contains(k)) continue;
                minus.put(k, me.getValue());
            }
        } else {
            minus.putAll(this);
            for (Object k : keys) {
                if (!this.containsKey(k)) continue;
                minus.remove(k);
            }
        }
        return minus;
    }

    @Override
    public final V put(K key, V value) {
        return this.getMap().put(key, value);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> t) {
        this.getMap().putAll(t);
    }

    @Override
    public final V remove(Object key) {
        return this.getMap().remove(key);
    }

    @Override
    public final int size() {
        return this.getMap().size();
    }

    public String toString() {
        return this.getMap().toString();
    }

    public final IntersectableMap<K, V> union(Map<K, V> otherMap) throws EqualKeyUnequalValuesException {
        IntersectableMap<K, V> union = this.getClone();
        for (Map.Entry<K, V> me : otherMap.entrySet()) {
            K key = me.getKey();
            V value = me.getValue();
            if (union.containsKey(key)) {
                V valueUnion = union.get(key);
                if (valueUnion.equals(value)) continue;
                throw new EqualKeyUnequalValuesException(key, value, valueUnion);
            }
            union.put(key, value);
        }
        return union;
    }

    public final Map<K, V> union(Map<K, V> otherMap, Class<Map<K, V>> resultClass) throws EqualKeyUnequalValuesException, InstantiationException, IllegalAccessException {
        IntersectableMap iterateMap;
        IntersectableMap<K, V> bulkMap;
        if (!Map.class.isAssignableFrom(resultClass)) {
            throw new IllegalArgumentException();
        }
        Map union = resultClass.newInstance();
        if (this.size() > otherMap.size()) {
            bulkMap = this;
            iterateMap = otherMap;
        } else {
            bulkMap = otherMap;
            iterateMap = this;
        }
        union.putAll(bulkMap);
        for (Map.Entry me : iterateMap.entrySet()) {
            Object key = me.getKey();
            Object value = me.getValue();
            if (union.containsKey(key)) {
                V valueUnion = union.get(key);
                if (valueUnion == null) {
                    union.put(key, value);
                    continue;
                }
                if (value == null || valueUnion.equals(value)) continue;
                throw new EqualKeyUnequalValuesException(key, value, valueUnion);
            }
            union.put(key, value);
        }
        return union;
    }

    @Override
    public final Collection<V> values() {
        return this.getMap().values();
    }
}

