/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import java.math.BigInteger;

public abstract class MyBigInteger {
    private static final char[] chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_-".toCharArray();
    private static final char[] reverseChars = MyBigInteger.initReverseChars();

    private static char[] initReverseChars() {
        char[] wReverseChars = new char[96];
        int i = 0;
        while (i < chars.length) {
            wReverseChars[MyBigInteger.chars[i] - 32] = (char)i;
            ++i;
        }
        return wReverseChars;
    }

    public static BigInteger getBigInteger(String s) {
        char[] digits64 = s.toCharArray();
        BigInteger wbi = BigInteger.ZERO;
        int ix = 0;
        while (ix < digits64.length) {
            wbi = wbi.shiftLeft(6).add(BigInteger.valueOf(reverseChars[digits64[ix] - 32]));
            ++ix;
        }
        return wbi;
    }

    public static String toString(BigInteger i) {
        if (i.signum() == 0) {
            return "0";
        }
        BigInteger tmp = i.abs();
        char[] digits64 = new char[(tmp.bitLength() - 1) / 6 + 1];
        int ix = digits64.length - 1;
        while (ix >= 0) {
            long w2 = 0xFFFFFFFFFFFFFFFL;
            long w = tmp.longValue() & 0xFFFFFFFFFFFFFFFL;
            tmp = tmp.shiftRight(60);
            while (w2 > 0L && ix >= 0) {
                digits64[ix--] = chars[(int)(w & 0x3FL)];
                w >>= 6;
                w2 >>= 6;
            }
        }
        StringBuilder buf = new StringBuilder(digits64.length + 1);
        if (i.signum() < 0) {
            buf.append('-');
        }
        buf.append(new String(digits64));
        return buf.toString();
    }
}

