/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.erwinsmout.MyResource;
import be.erwinsmout.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public abstract class MyCertificate {
    public static final String RESOURCETYPE = "certificate";
    public static final String SUFFIX = ".certificate";
    public static final String X509CERTIFICATETYPE = "X.509";

    protected static String getCertificateBaseName(Class<?> clazz) {
        return MyResource.getResourceBaseName(clazz, RESOURCETYPE);
    }

    public static Certificate getCertificate(Class<?> clazz) throws CertificateException, NotFoundException, IOException, CertificateException {
        return MyCertificate.getCertificate(clazz, X509CERTIFICATETYPE);
    }

    public static Certificate getCertificate(Class<?> clazz, String certificateType) throws CertificateException, NotFoundException, IOException, CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(certificateType);
        InputStream inputStream = MyCertificate.getCertificateInputStream(clazz);
        try {
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            return certificate;
        }
        finally {
            inputStream.close();
        }
    }

    public static InputStream getCertificateInputStream(Class<?> clazz) throws NotFoundException {
        return MyResource.getResourceInputStream(clazz, MyCertificate.getCertificateBaseName(clazz));
    }

    public static Certificate getPackageCertificate(Class<?> clazz) throws CertificateException, NotFoundException, IOException, CertificateException {
        return MyCertificate.getPackageCertificate(clazz, X509CERTIFICATETYPE);
    }

    public static Certificate getPackageCertificate(Class<?> clazz, String certificateType) throws CertificateException, NotFoundException, IOException, CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(certificateType);
        InputStream inputStream = MyCertificate.getPackageCertificateInputStream(clazz);
        try {
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            return certificate;
        }
        finally {
            inputStream.close();
        }
    }

    public static InputStream getPackageCertificateInputStream(Class<?> clazz) throws NotFoundException {
        try {
            return MyResource.getResourceInputStream(clazz, RESOURCETYPE);
        }
        catch (NotFoundException notFoundException) {
            throw new NotFoundException();
        }
    }

    private MyCertificate() {
    }
}

