/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.erwinsmout.NotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class MyCipherInputStream
extends FilterInputStream {
    private int currentOffset = -1;
    private byte[] decryptedBuffer;
    private BigInteger decryptExponent;
    private BigInteger modulus;

    public MyCipherInputStream(InputStream inputStream, BigInteger decryptExponent, BigInteger modulus) {
        super(inputStream);
        this.decryptExponent = decryptExponent;
        this.modulus = modulus;
    }

    private void getChunk() throws IOException, NotFoundException {
        int originalInputLength1 = this.in.read();
        if (originalInputLength1 < 0) {
            throw new NotFoundException();
        }
        int originalInputLength2 = this.in.read();
        int originalInputLength3 = this.in.read();
        int originalInputLength4 = this.in.read();
        if (originalInputLength2 < 0 || originalInputLength3 < 0 || originalInputLength4 < 0) {
            throw new IOException();
        }
        int originalInputLength = (originalInputLength1 << 24) + (originalInputLength2 << 16) + (originalInputLength3 << 8) + originalInputLength4;
        boolean swapSign = false;
        if (originalInputLength < 0) {
            swapSign = true;
            originalInputLength = -originalInputLength;
        }
        this.decryptedBuffer = new byte[originalInputLength];
        int length1 = this.in.read();
        int length2 = this.in.read();
        int length3 = this.in.read();
        int length4 = this.in.read();
        if (length1 < 0 || length2 < 0 || length3 < 0 || length4 < 0) {
            throw new IOException();
        }
        int encryptedlength = (length1 << 24) + (length2 << 16) + (length3 << 8) + length4;
        if (this.modulus.compareTo(BigInteger.valueOf(2L).pow(8 * encryptedlength)) >= 0) {
            throw new IOException();
        }
        byte[] encryptedBuffer = new byte[encryptedlength];
        int byteCount = this.in.read(encryptedBuffer);
        if (byteCount < encryptedBuffer.length) {
            throw new IOException();
        }
        byte[] shortDecryptedBuffer = new BigInteger(encryptedBuffer).modPow(this.decryptExponent, this.modulus).toByteArray();
        if (swapSign) {
            shortDecryptedBuffer = new BigInteger(shortDecryptedBuffer).negate().toByteArray();
        }
        System.arraycopy(shortDecryptedBuffer, 0, this.decryptedBuffer, this.decryptedBuffer.length - shortDecryptedBuffer.length, shortDecryptedBuffer.length);
        this.currentOffset = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.currentOffset < 0 || this.currentOffset >= this.decryptedBuffer.length) {
            try {
                this.getChunk();
            }
            catch (NotFoundException notFoundException) {
                return -1;
            }
        }
        return this.decryptedBuffer[this.currentOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int p = off;
        while (p < off + len) {
            int ibyte = this.read();
            if (ibyte < 0) {
                return p == off ? -1 : p - off;
            }
            b[p] = (byte)ibyte;
            ++p;
        }
        return len;
    }
}

