/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class MyCipherOutputStream
extends FilterOutputStream {
    private int currentOffset = 0;
    private byte[] decryptedBuffer;
    private BigInteger encryptExponent;
    private BigInteger modulus;

    public MyCipherOutputStream(OutputStream outputStream, BigInteger encryptExponent, BigInteger modulus) {
        super(outputStream);
        this.encryptExponent = encryptExponent;
        this.modulus = modulus;
        int blockSize = modulus.bitLength() / 32 * 4;
        this.decryptedBuffer = new byte[blockSize];
    }

    private void writeBigIntegerBytes(byte[] decryptedBufferToWrite) throws IOException {
        BigInteger decryptedBigInteger = new BigInteger(decryptedBufferToWrite);
        int swapSign = 1;
        if (decryptedBigInteger.signum() < 0) {
            swapSign = -1;
            decryptedBigInteger = decryptedBigInteger.negate();
        }
        byte[] encryptedLicenseBytes = decryptedBigInteger.modPow(this.encryptExponent, this.modulus).toByteArray();
        int originalInputLength = decryptedBufferToWrite.length * swapSign;
        this.out.write(originalInputLength >> 24);
        this.out.write((originalInputLength & 0xFF0000) >> 16);
        this.out.write((originalInputLength & 0xFF00) >> 8);
        this.out.write(originalInputLength & 0xFF);
        int length = encryptedLicenseBytes.length;
        this.out.write(length >> 24);
        this.out.write((length & 0xFF0000) >> 16);
        this.out.write((length & 0xFF00) >> 8);
        this.out.write(length & 0xFF);
        this.out.write(encryptedLicenseBytes);
        this.currentOffset = 0;
    }

    private void writeIncompleteBlock() throws IOException {
        if (this.currentOffset > 0) {
            byte[] shortDecryptedBuffer = new byte[this.currentOffset];
            System.arraycopy(this.decryptedBuffer, 0, shortDecryptedBuffer, 0, this.currentOffset);
            this.writeBigIntegerBytes(shortDecryptedBuffer);
        }
    }

    @Override
    public void close() throws IOException {
        this.writeIncompleteBlock();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.writeIncompleteBlock();
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.decryptedBuffer[this.currentOffset++] = (byte)(b & 0xFF);
        if (this.currentOffset >= this.decryptedBuffer.length) {
            this.writeBigIntegerBytes(this.decryptedBuffer);
        }
    }
}

