/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.util.PrematureEOFException;
import be.erwinsmout.MyMessageFormat;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class MyDataInputStream {
    public static String getBigUTFString(DataInputStream in) throws IOException {
        int charLength = in.readInt();
        int byteLength = in.readInt();
        StringBuffer str = new StringBuffer(charLength);
        byte[] bytearr = new byte[byteLength];
        int count = 0;
        in.readFully(bytearr, 0, byteLength);
        while (count < byteLength) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > byteLength) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    char appendChar = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    str.append(appendChar);
                    break;
                }
                case 14: {
                    if ((count += 3) > byteLength) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    char appendChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    str.append(appendChar);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(str);
    }

    public static String getSmallUTFString(DataInputStream in) throws IOException, UTFDataFormatException {
        short charLength = in.readShort();
        short byteLength = in.readShort();
        String clientSignatureProtocolName = MyDataInputStream.getUTFString(in, charLength, byteLength);
        return clientSignatureProtocolName;
    }

    public static String getUTFString(DataInputStream in, int charlength, int byteLength) throws IOException, UTFDataFormatException {
        char[] chars = new char[charlength];
        int c = 0;
        int bytes = 0;
        while (c < charlength && bytes < byteLength) {
            char rc;
            int b = in.readUnsignedByte();
            ++bytes;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    rc = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    int b2 = in.readUnsignedByte();
                    ++bytes;
                    if ((b2 & 0xC0) != 128) {
                        throw new UTFDataFormatException(MyMessageFormat.format("Received UTF byte 2 {0}.", new String[]{Integer.toHexString(b2)}));
                    }
                    rc = (char)((b & 0x1F) << 6 | b2 & 0x3F);
                    break;
                }
                case 14: {
                    int b2 = in.readUnsignedByte();
                    ++bytes;
                    int b3 = in.readUnsignedByte();
                    ++bytes;
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        throw new UTFDataFormatException(MyMessageFormat.format("Received UTF bytes 2-3 {0}-{1}.", new String[]{Integer.toHexString(b2), Integer.toHexString(b3)}));
                    }
                    rc = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException(MyMessageFormat.format("First UTF byte {0} received.", new String[]{Integer.toHexString(b)}));
                }
            }
            chars[c++] = rc;
        }
        if (c != charlength || bytes != byteLength) {
            throw new UTFDataFormatException(MyMessageFormat.format("Specified byte length {0} and char length {1} did not match with UTF data found.  Processed {2} bytes and found {3} chars.", new String[]{Integer.toString(byteLength), Integer.toString(charlength), Integer.toString(bytes), Integer.toString(c)}));
        }
        return new String(chars);
    }

    public static byte[] readExactNumberOfBytes(DataInputStream in, int byteCount) throws IOException {
        byte[] inputBytes = new byte[byteCount];
        int totalBytesRead = 0;
        while (totalBytesRead != byteCount) {
            int bytesRead = in.read(inputBytes, totalBytesRead, byteCount - totalBytesRead);
            if (bytesRead < 0) {
                throw new PrematureEOFException(totalBytesRead, byteCount);
            }
            totalBytesRead += bytesRead;
        }
        return inputBytes;
    }
}

