/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.erwinsmout.MyResource;
import be.erwinsmout.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public abstract class MyKeyStore {
    public static final String RESOURCETPYE = "keystore";
    public static final String SUFFIX = ".keystore";

    protected static String getKeystoreBaseName(Class<?> clazz) {
        return MyResource.getResourceBaseName(clazz, RESOURCETPYE);
    }

    protected static String getPackageKeystoreBaseName(Class<?> clazz) {
        return MyResource.getPackageResourceBaseName(clazz, RESOURCETPYE);
    }

    public static KeyStore getKeyStore(Class<?> clazz) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        return MyKeyStore.getKeyStore(clazz, "JKS");
    }

    public static KeyStore getKeyStore(Class<?> clazz, char[] storePassword) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        return MyKeyStore.getKeyStore(clazz, "JKS", storePassword);
    }

    public static KeyStore getKeyStore(Class<?> clazz, String keyStoreType) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        return MyKeyStore.getKeyStore(clazz, keyStoreType, clazz.getSimpleName().toCharArray());
    }

    public static KeyStore getKeyStore(Class<?> clazz, String keyStoreType, char[] storePassword) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore jks = KeyStore.getInstance(keyStoreType);
        InputStream inputStream = MyKeyStore.getKeyStoreInputStream(clazz);
        try {
            jks.load(inputStream, storePassword);
        }
        finally {
            inputStream.close();
        }
        return jks;
    }

    public static KeyStore getKeyStore(String user) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NotFoundException {
        return MyKeyStore.getKeyStore(user, "JKS");
    }

    public static KeyStore getKeyStore(String user, char[] storePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NotFoundException {
        return MyKeyStore.getKeyStore(user, "JKS", storePassword);
    }

    public static KeyStore getKeyStore(String user, String keyStoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NotFoundException {
        return MyKeyStore.getKeyStore(user, keyStoreType, user.toCharArray());
    }

    public static KeyStore getKeyStore(String user, String keyStoreType, char[] storePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NotFoundException {
        KeyStore jks = KeyStore.getInstance(keyStoreType);
        InputStream inputStream = MyKeyStore.getKeyStoreInputStream(user);
        try {
            jks.load(inputStream, storePassword);
        }
        finally {
            inputStream.close();
        }
        return jks;
    }

    public static InputStream getKeyStoreInputStream(Class<?> clazz) throws NotFoundException {
        return MyResource.getResourceInputStream(clazz, MyKeyStore.getKeystoreBaseName(clazz));
    }

    public static InputStream getKeyStoreInputStream(String user) throws NotFoundException {
        return MyResource.getResourceInputStream(user);
    }

    public static KeyStore getPackageKeyStore(Class<?> clazz) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        return MyKeyStore.getPackageKeyStore(clazz, "JKS");
    }

    public static KeyStore getPackageKeyStore(Class<?> clazz, char[] storePassword) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        return MyKeyStore.getPackageKeyStore(clazz, "JKS", storePassword);
    }

    public static KeyStore getPackageKeyStore(Class<?> clazz, String keyStoreType) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        return MyKeyStore.getPackageKeyStore(clazz, keyStoreType, clazz.getSimpleName().toCharArray());
    }

    public static KeyStore getPackageKeyStore(Class<?> clazz, String keyStoreType, char[] storePassword) throws KeyStoreException, NotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore jks = KeyStore.getInstance(keyStoreType);
        InputStream inputStream = MyKeyStore.getPackageKeyStoreInputStream(clazz);
        try {
            jks.load(inputStream, storePassword);
        }
        finally {
            inputStream.close();
        }
        return jks;
    }

    public static InputStream getPackageKeyStoreInputStream(Class<?> clazz) throws NotFoundException {
        return MyResource.getResourceInputStream(clazz, MyKeyStore.getPackageKeystoreBaseName(clazz));
    }

    private MyKeyStore() {
    }
}

