/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.util.MyListSetIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public final class MyListSet<E>
implements Set<E> {
    private LinkedList<E> elements;
    private int hashCode;
    private boolean hashCodeObsolete;

    public MyListSet(Collection<E> contents) {
        this(new HashSet<E>(contents));
    }

    public MyListSet(Set<E> entrySet) {
        this.elements = new LinkedList<E>(entrySet);
        this.hashCode = entrySet.hashCode();
        this.hashCodeObsolete = false;
    }

    private int computeHashCode() {
        return new HashSet<E>(this.elements).hashCode();
    }

    void obsoleteHashCode() {
        this.hashCodeObsolete = true;
    }

    @Override
    public boolean add(E e) {
        boolean added;
        boolean bl = added = !this.contains(e);
        if (added) {
            this.elements.addLast(e);
        }
        this.hashCodeObsolete |= added;
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        this.hashCodeObsolete |= changed;
        return changed;
    }

    @Override
    public void clear() {
        if (this.elements.size() > 0) {
            this.elements.clear();
            this.obsoleteHashCode();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Set && ((Set)obj).size() == this.elements.size() && ((Set)obj).containsAll(this.elements);
    }

    @Override
    public int hashCode() {
        return this.hashCodeObsolete ? (this.hashCode = this.computeHashCode()) : this.hashCode;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new MyListSetIterator(this, this.elements.iterator());
    }

    @Override
    public boolean remove(Object o) {
        this.hashCodeObsolete = this.elements.remove(o);
        return this.hashCodeObsolete;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.hashCodeObsolete = this.elements.removeAll(c);
        return this.hashCodeObsolete;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.hashCodeObsolete = this.elements.retainAll(c);
        return this.hashCodeObsolete;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    public String toString() {
        return this.elements.toString();
    }
}

