/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.util.MyKeyStore;
import be.erwinsmout.NotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public class UserPrivateKeyProvider
implements Signer {
    private KeyStore keyStore;
    private String user;

    public UserPrivateKeyProvider(String user) throws NotFoundException {
        this.user = user;
        try {
            this.keyStore = MyKeyStore.getKeyStore(user);
        }
        catch (KeyStoreException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (CertificateException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (IOException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
    }

    private PrivateKey getPrivateKey(String algorithm) throws NotFoundException {
        try {
            return (PrivateKey)this.keyStore.getKey(String.valueOf(this.user) + algorithm, this.user.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (UnrecoverableKeyException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
    }

    @Override
    public byte[] sign(Signature signature, byte[] signMessage) throws InvalidKeyException, SignatureException, NotFoundException {
        signature.initSign(this.getPrivateKey(signature.getAlgorithm()));
        signature.update(signMessage);
        return signature.sign();
    }
}

