/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.Heading;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.TypeIsScalarException;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.DuplicateNameException;
import be.SIRAPRISE.util.IntersectableMap;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.WAAR.PresentationLayer.DynamicColumnListValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.List;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarException;
import be.erwinsmout.NotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class WaarListFactory {
    public static ListValue fromSiraPriseRelationValue(PresentationField listField, String relationValue, UserData userData, Locale locale) throws WaarException {
        ListValue listValue = new ListValue(listField.getName());
        try {
            String val = relationValue.length() > 7 && relationValue.substring(0, 8).equalsIgnoreCase("RELATION") ? BracketParser.getNameValueFromEscaped(relationValue, 0).getNameValuePair().getValue() : relationValue.trim();
            HashMap<String, String> m0 = BracketParser.createMapFromEscaped(val);
            if (m0.containsKey("BODY")) {
                val = m0.get("BODY");
                LinkedList<String> tuples = BracketParser.createListFromEscaped(val);
                Iterator i_tuples = tuples.iterator();
                while (i_tuples.hasNext()) {
                    HashMap<String, ListValue> m = new HashMap<String, ListValue>();
                    String tupleValue = (String)i_tuples.next();
                    HashMap<String, String> am = BracketParser.createMapFromEscaped(tupleValue);
                    for (Map.Entry<String, String> me : am.entrySet()) {
                        String attributeName = me.getKey();
                        String attributeValue = me.getValue();
                        PresentationField listColumnField = listField.getColumn(attributeName, locale);
                        if (listColumnField == null) continue;
                        Object listAttributeValue = listColumnField.getType() instanceof List ? WaarListFactory.fromSiraPriseRelationValue(listColumnField, attributeValue, userData, locale) : listColumnField.getType().encode(attributeValue, userData, locale);
                        m.put(attributeName, (ListValue)listAttributeValue);
                    }
                    listValue.append(m);
                }
                return listValue;
            }
            throw new InvalidAttributeValueException(relationValue, "List", "Relation value specification does not contain a BODY()", locale);
        }
        catch (NoClosingBracketException noClosingBracketException) {
            throw new InvalidAttributeValueException(relationValue, "List", "Relation value specification does not contain a BODY()", locale);
        }
        catch (DuplicateNameException duplicateNameException) {
            throw new InvalidAttributeValueException(relationValue, "List", "A duplicate name was encountered in the response.", locale);
        }
        catch (NoOpeningBracketException noOpeningBracketException) {
            throw new InvalidAttributeValueException(relationValue, "List", "Relation value specification does not contain a BODY()", locale);
        }
        catch (InvalidEscapedCharacterException e1) {
            throw new RuntimeException(e1);
        }
        catch (MissingEscapedCharacterException e1) {
            throw new RuntimeException(e1);
        }
    }

    private static DynamicColumnListValue varColumnListFromSiraPriseRelationBody(String listFieldName, Heading rvaHeadingType, String bodyContent, Locale locale) throws WaarException {
        try {
            DynamicColumnListValue listValue = new DynamicColumnListValue(listFieldName);
            Set<String> columns = rvaHeadingType.getAttributeNames();
            listValue.addColumns(columns);
            LinkedList<String> tuples = BracketParser.createListFromEscaped(bodyContent);
            Iterator i_tuples = tuples.iterator();
            while (i_tuples.hasNext()) {
                HashMap<String, GenericStringValue> m = new HashMap<String, GenericStringValue>();
                String tupleValue = (String)i_tuples.next();
                HashMap<String, String> attributeValues = BracketParser.createMapFromEscaped(tupleValue);
                for (Map.Entry me : rvaHeadingType.entrySet()) {
                    GenericStringValue listAttributeValue;
                    String attributeName = (String)me.getKey();
                    Object columnType = me.getValue();
                    String attributeValue = attributeValues.get(attributeName);
                    if (columnType instanceof Heading) {
                        String innerBodyContent;
                        Heading innerHeadingType;
                        try {
                            innerHeadingType = rvaHeadingType.getHeading(attributeName);
                        }
                        catch (NotFoundException impossible) {
                            throw new RuntimeException(impossible);
                        }
                        catch (TypeIsScalarException impossible) {
                            throw new RuntimeException(impossible);
                        }
                        try {
                            innerBodyContent = BracketParser.getNameValueFromEscaped(attributeValue, 0).getNameValuePair().getValue();
                        }
                        catch (InvalidEscapedCharacterException e1) {
                            throw new RuntimeException(e1);
                        }
                        catch (MissingEscapedCharacterException e1) {
                            throw new RuntimeException(e1);
                        }
                        listAttributeValue = WaarListFactory.varColumnListFromSiraPriseRelationBody(attributeName, innerHeadingType, innerBodyContent, locale);
                    } else {
                        listAttributeValue = new GenericStringValue(BracketParser.unMeta(attributeValue));
                    }
                    m.put(attributeName, listAttributeValue);
                }
                listValue.append(m);
            }
            return listValue;
        }
        catch (NoClosingBracketException e) {
            throw new RuntimeException(e);
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException(e);
        }
        catch (NoOpeningBracketException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
    }

    public static DynamicColumnListValue varColumnListFromSiraPriseQueryResponse(String listFieldName, AbstractRelation relation, Locale locale) throws WaarException {
        DynamicColumnListValue listValue = new DynamicColumnListValue(listFieldName);
        Heading heading = relation.getHeading();
        for (Map.Entry me : heading.entrySet()) {
            String attributeName = (String)me.getKey();
            listValue.addColumn(attributeName);
        }
        Iterator<Tuple> i_tuples = relation.iterator();
        while (i_tuples.hasNext()) {
            HashMap<String, GenericStringValue> m = new HashMap<String, GenericStringValue>();
            AbstractTuple tuple = (AbstractTuple)i_tuples.next();
            IntersectableMap<?, ?> tupleAttributeValues = tuple.values();
            for (Map.Entry me : tupleAttributeValues.entrySet()) {
                GenericStringValue listAttributeValue;
                String columnType;
                String attributeName = (String)me.getKey();
                String attributeValue = (String)me.getValue();
                try {
                    columnType = heading.getTypeName(attributeName);
                }
                catch (NotFoundException impossible) {
                    throw new RuntimeException(impossible);
                }
                if (columnType.toUpperCase().startsWith("RELATION")) {
                    String innerBodyContent;
                    Heading rvaHeadingType;
                    try {
                        rvaHeadingType = heading.getHeading(attributeName);
                    }
                    catch (NotFoundException impossible) {
                        throw new RuntimeException(impossible);
                    }
                    catch (TypeIsScalarException impossible) {
                        throw new RuntimeException(impossible);
                    }
                    try {
                        innerBodyContent = BracketParser.getNameValueFromEscaped(attributeValue, 0).getNameValuePair().getValue();
                    }
                    catch (NoClosingBracketException e3) {
                        throw new RuntimeException(e3);
                    }
                    catch (InvalidEscapedCharacterException e) {
                        throw new RuntimeException(e);
                    }
                    catch (MissingEscapedCharacterException e) {
                        throw new RuntimeException(e);
                    }
                    listAttributeValue = WaarListFactory.varColumnListFromSiraPriseRelationBody(attributeName, rvaHeadingType, innerBodyContent, locale);
                } else {
                    try {
                        listAttributeValue = new GenericStringValue(BracketParser.unMeta(attributeValue));
                    }
                    catch (InvalidEscapedCharacterException e) {
                        throw new RuntimeException(e);
                    }
                    catch (MissingEscapedCharacterException e) {
                        throw new RuntimeException(e);
                    }
                }
                m.put(attributeName, listAttributeValue);
            }
            listValue.append(m);
        }
        return listValue;
    }
}

