/*
 * Decompiled with CFR 0.152.
 */
package be.erwinsmout;

import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.MyResource;
import be.erwinsmout.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MyProperties
extends Properties {
    private static final String PROPERTIES = "properties";
    private static final long serialVersionUID = 4230868963188380737L;
    public static final String SUFFIX = ".properties";

    private static void load(Properties properties) {
        block13: {
            Class<?> propertiesClass = properties.getClass();
            String propertiesResourceName = MyProperties.getPropertiesBaseName(propertiesClass);
            try {
                InputStream propertiesStream = MyResource.getResourceInputStream(propertiesClass, propertiesResourceName);
                try {
                    try {
                        properties.load(propertiesStream);
                    }
                    catch (IOException e) {
                        Logger.getLogger(properties.getClass().getName()).log(Level.SEVERE, MyMessageFormat.format("IO Exception loading properties for {0}", new String[]{propertiesResourceName}), e);
                        try {
                            propertiesStream.close();
                        }
                        catch (IOException e2) {
                            Logger.getLogger(properties.getClass().getName()).log(Level.SEVERE, MyMessageFormat.format("IO Exception closing properties stream for {0}", new String[]{propertiesResourceName}), e2);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        propertiesStream.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(properties.getClass().getName()).log(Level.SEVERE, MyMessageFormat.format("IO Exception closing properties stream for {0}", new String[]{propertiesResourceName}), e);
                    }
                    throw throwable;
                }
                try {
                    propertiesStream.close();
                }
                catch (IOException e) {
                    Logger.getLogger(properties.getClass().getName()).log(Level.SEVERE, MyMessageFormat.format("IO Exception closing properties stream for {0}", new String[]{propertiesResourceName}), e);
                }
            }
            catch (NotFoundException notFoundException) {
                Logger.getLogger(properties.getClass().getName()).info(MyMessageFormat.format("No resource found to load {0} from.", new String[]{properties.getClass().getName()}));
            }
        }
    }

    protected static String getPropertiesBaseName(Class<? extends Properties> propertiesClass) {
        return MyResource.getResourceBaseName(propertiesClass, PROPERTIES);
    }

    public static String resolveSystemPropertyRefs(String propertyValue) {
        int i2;
        int i1;
        String resolvedPropertyValue = propertyValue;
        do {
            i1 = resolvedPropertyValue.indexOf("${");
            i2 = resolvedPropertyValue.indexOf(125, i1);
            if (i1 < 0 || i2 <= i1) continue;
            resolvedPropertyValue = String.valueOf(resolvedPropertyValue.substring(0, i1)) + System.getProperty(resolvedPropertyValue.substring(i1 + 2, i2), "") + resolvedPropertyValue.substring(i2 + 1);
        } while (i1 >= 0 && i2 > i1);
        return resolvedPropertyValue;
    }

    public MyProperties() {
        this(false);
    }

    public MyProperties(boolean resolveSystemPropertyReferences) {
        MyProperties.load(this);
        if (resolveSystemPropertyReferences) {
            this.resolveSystemPropertyRefs();
        }
    }

    public MyProperties(Properties defaults) {
        this(defaults, false);
    }

    public MyProperties(Properties defaults, boolean resolveSystemPropertyReferences) {
        super(defaults);
        MyProperties.load(this);
        if (resolveSystemPropertyReferences) {
            this.resolveSystemPropertyRefs();
        }
    }

    public MyProperties(SKIPAUTOLOAD skipAutoLoad) {
        skipAutoLoad.getClass();
    }

    private void resolveSystemPropertyRefs() {
        for (Map.Entry<Object, Object> me : this.entrySet()) {
            this.setProperty((String)me.getKey(), MyProperties.resolveSystemPropertyRefs((String)me.getValue()));
        }
    }

    public static class SKIPAUTOLOAD {
    }
}

