/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.Heading;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.TupleContainer;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.erwinsmout.MyMessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTupleContainer
implements TupleContainer {
    private Heading hM;

    public AbstractTupleContainer(Heading heading) {
        this.hM = heading;
    }

    @Override
    public final void addTuplesWithHeadingCheck(TupleContainer tupleContainer) {
        for (Tuple tuple : tupleContainer) {
            this.addTupleWithHeadingCheck(tuple);
        }
    }

    @Override
    public final void addTuplesWithoutHeadingCheck(TupleContainer tupleContainer) {
        for (Tuple tuple : tupleContainer) {
            this.addTupleWithoutHeadingCheck(tuple);
        }
    }

    @Override
    public final void addTupleWithHeadingCheck(Tuple tuple) {
        if (!tuple.getHeading().keySet().equals(this.getHeading().keySet())) {
            throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("AbstractRelation.HeadingMismatch"), new Object[]{tuple, this.getHeading().keySet()}));
        }
        this.addTupleWithoutHeadingCheck(tuple);
    }

    @Override
    public abstract void addTupleWithoutHeadingCheck(Tuple var1);

    @Override
    public final Heading getHeading() {
        return this.hM;
    }

    @Override
    public abstract Iterator iterator();

    public final String printBodyEscapedWithBodyHeaderWithoutTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("BODY").append("(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueEscapedWithoutTypeNames());
        }
        return stringBuilder.append(')').toString();
    }

    public final String printBodyEscapedWithBodyHeaderWithTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("BODY").append("(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueEscapedWithTypeNames());
        }
        return stringBuilder.append(')').toString();
    }

    public final String printBodyEscapedWithoutBodyHeaderWithoutTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueEscapedWithoutTypeNames());
        }
        return stringBuilder.toString();
    }

    public final String printBodyEscapedWithoutBodyHeaderWithTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueEscapedWithTypeNames());
        }
        return stringBuilder.toString();
    }

    public final String printBodyWithBodyHeaderWithoutTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("BODY").append("(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueWithoutTypeNames());
        }
        return stringBuilder.append(')').toString();
    }

    public final String printBodyWithBodyHeaderWithTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("BODY").append("(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueWithTypeNames());
        }
        return stringBuilder.append(')').toString();
    }

    public final String printBodyWithoutBodyHeaderWithoutTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueWithoutTypeNames());
        }
        return stringBuilder.toString();
    }

    public final String printBodyWithoutBodyHeaderWithTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueWithTypeNames());
        }
        return stringBuilder.toString();
    }

    public final String printBodyXMLWithBodyHeader() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("<Body>");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueXML());
        }
        return stringBuilder.append("</Body>").toString();
    }

    public final String printBodyXMLWithoutBodyHeader() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueXML());
        }
        return stringBuilder.toString();
    }

    @Override
    public final String printValueEscapedWithoutTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("RELATION").append("(").append(this.hM.print()).append("BODY").append("(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueEscapedWithoutTypeNames());
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    @Override
    public final String printValueEscapedWithTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("RELATION").append("(").append(this.hM.print()).append("BODY").append("(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueEscapedWithTypeNames());
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    @Override
    public final String printValueWithoutTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("RELATION(").append(this.hM.print()).append("BODY(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueWithoutTypeNames());
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    @Override
    public final String printValueWithTypeNames() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("RELATION").append("(").append(this.hM.print()).append("BODY").append("(");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueWithTypeNames());
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    @Override
    public final String printValueXML() {
        StringBuilder stringBuilder = new StringBuilder(256 * this.size());
        stringBuilder.append("<Relation>").append(this.hM.printXML()).append("<Body>");
        for (Tuple tuple : this) {
            stringBuilder.append(tuple.printValueXML());
        }
        stringBuilder.append("</Body></Relation>");
        return stringBuilder.toString();
    }

    @Override
    public abstract boolean removeTuple(Tuple var1);

    @Override
    public final int removeTuples(TupleContainer tupleContainer) {
        int n2 = 0;
        for (Tuple tuple : tupleContainer) {
            if (!this.removeTuple(tuple)) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public abstract int size();

    @Override
    public final Object[] toObjectArray(Class clazz) {
        return DBObjectFactory.getObjectArray(this, clazz);
    }

    @Override
    public final Object[] toObjectArrayIgnoringMissingSetters(Class clazz) {
        return DBObjectFactory.getObjectArrayIgnoringMissingSetters(this, clazz);
    }

    @Override
    public final Collection toObjectCollection(Class clazz) {
        return DBObjectFactory.getObjectCollection(this, clazz);
    }

    @Override
    public final Collection toObjectCollectionIgnoringMissingSetters(Class clazz) {
        DBObjectFactory.getPublicNoArgConstructor(clazz);
        HashMap hashMap = DBObjectFactory.getSetterMethods(clazz, this.hM);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Tuple tuple : this) {
            arrayList.add(DBObjectFactory.getObject(tuple, clazz, hashMap));
        }
        return arrayList;
    }

    @Override
    public final Map[] toObjectsArray(Class[] classArray) {
        return (Map[])this.toObjectsCollection(classArray).toArray();
    }

    @Override
    public final Collection toObjectsCollection(Class[] classArray) {
        Set set = this.getHeading().keySet();
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        HashMap<Class, HashMap> hashMap = new HashMap<Class, HashMap>();
        int n2 = 0;
        while (n2 < classArray.length) {
            DBObjectFactory.getPublicNoArgConstructor(classArray[n2]);
            Object object = DBObjectFactory.getSetterMethods(classArray[n2], this.hM);
            hashMap.put(classArray[n2], (HashMap)object);
            hashSet.removeAll(hashMap.keySet());
            ++n2;
        }
        if (hashSet.size() > 0) {
            throw new SettersMissingException(hashSet.toString());
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        for (Object object : this) {
            arrayList.add(DBObjectFactory.toObjects((Tuple)object, hashMap));
        }
        return arrayList;
    }

    public final String toString() {
        return this.printValueWithoutTypeNames();
    }
}

