/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.DmlAssertCommand;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.DmlCommand;
import be.SIRAPRISE.client.DmlDeleteCommand;
import be.SIRAPRISE.client.DmlUnassertCommand;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.IllegalTransactionStateException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.client.jsba.DBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import java.util.Collection;

public class DBTransaction {
    private boolean jW;
    private DBConnection In;
    private DBTransaction Io;
    private DBTransaction Ip;
    private long oW;
    private TransactionMode Iq;
    private String iv;

    DBTransaction(DBTransaction dBTransaction, boolean bl2, long l2, TransactionMode transactionMode) {
        this.Ip = dBTransaction;
        this.iv = dBTransaction.iv;
        this.In = dBTransaction.In;
        this.jW = bl2;
        this.oW = l2;
        this.Iq = transactionMode;
    }

    DBTransaction(String string, boolean bl2, DBConnection dBConnection, long l2, TransactionMode transactionMode) {
        this.iv = string;
        this.jW = bl2;
        this.In = dBConnection;
        this.oW = l2;
        this.Iq = transactionMode;
    }

    private void jn() {
        if (this.In == null) {
            throw new IllegalTransactionStateException();
        }
    }

    private AbstractRelation f(ServerCommand serverCommand) {
        try {
            return this.In.e(serverCommand);
        }
        catch (ConnectionClosedException connectionClosedException) {
            this.In = null;
            throw connectionClosedException;
        }
    }

    private AbstractRelation an(String string) {
        try {
            AbstractRelation abstractRelation = this.In.ak(string);
            if (!(!this.jW || !this.In.getSpecificationVersionForServer().isBefore(Version.ONE_TWO) || string.length() > 7 && string.substring(0, 8).equalsIgnoreCase("ROLLBACK") || string.length() > 5 && string.substring(0, 6).equalsIgnoreCase("COMMIT"))) {
                this.In.iP();
            }
            return abstractRelation;
        }
        catch (ConnectionClosedException connectionClosedException) {
            this.In = null;
            throw connectionClosedException;
        }
        catch (ErrorMessageException errorMessageException) {
            if (this.In.getSpecificationVersionForServer().isBefore(Version.ONE_TWO)) {
                this.In = null;
            }
            throw errorMessageException;
        }
    }

    public final void commit() {
        this.jn();
        if (!this.jW || this.In.getSpecificationVersionForServer().isBefore(Version.ONE_TWO)) {
            try {
                this.In.iQ();
            }
            catch (ConnectionClosedException connectionClosedException) {
                this.In = null;
                throw connectionClosedException;
            }
        }
    }

    public final AbstractRelation compileAndCacheQuery(String string) {
        return this.execDmlCommand("CACHE " + string);
    }

    public final AbstractRelation compileQuery(String string) {
        return this.execDmlCommand("COMPILE " + string);
    }

    public final void dbAdd(String string, DBObject dBObject) {
        this.execDmlCommand(this.dbAddCommand(string, dBObject));
    }

    public final void dbAddAndEndTransaction(String string, DBObject dBObject) {
        try {
            this.dbAdd(string, dBObject);
            this.end(true);
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final DmlAddCommand dbAddCommand(String string, DBObject dBObject) {
        return new DmlAddCommand(string, dBObject);
    }

    public final void dbAssert(String string, DBObject dBObject) {
        this.execDmlCommand(this.dbAssertCommand(string, dBObject));
    }

    public final void dbAssertAndEndTransaction(String string, DBObject dBObject) {
        try {
            this.dbAssert(string, dBObject);
            this.end(true);
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final DmlAssertCommand dbAssertCommand(String string, DBObject dBObject) {
        return new DmlAssertCommand(string, dBObject);
    }

    public final void dbDelete(String string, DBObject dBObject) {
        this.execDmlCommand(this.dbDeleteCommand(string, dBObject));
    }

    public final void dbDeleteAndEndTransaction(String string, DBObject dBObject) {
        try {
            this.dbDelete(string, dBObject);
            this.end(true);
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final DmlDeleteCommand dbDeleteCommand(String string, DBObject dBObject) {
        return new DmlDeleteCommand(string, dBObject);
    }

    public final void dbUnAssert(String string, DBObject dBObject) {
        this.execDmlCommand(this.dbUnAssertCommand(string, dBObject));
    }

    public final void dbUnAssertAndEndTransaction(String string, DBObject dBObject) {
        try {
            this.dbUnAssert(string, dBObject);
            this.end(true);
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final DmlUnassertCommand dbUnAssertCommand(String string, DBObject dBObject) {
        return new DmlUnassertCommand(string, dBObject);
    }

    public final void dbUpdate(String string, UpdatableDBObject updatableDBObject) {
        try {
            this.execDmlCommand(this.dbUpdateCommand(string, updatableDBObject));
        }
        catch (NoUpdatesException noUpdatesException) {}
    }

    public final void dbUpdateAndEndTransaction(String string, UpdatableDBObject updatableDBObject) {
        try {
            this.dbUpdate(string, updatableDBObject);
            this.end(true);
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final DmlUpdateCommand dbUpdateCommand(String string, UpdatableDBObject updatableDBObject) {
        return new DmlUpdateCommand(string, updatableDBObject);
    }

    public final void end(boolean bl2) {
        this.jn();
        try {
            this.In.b(bl2, this.oW);
        }
        finally {
            this.In = null;
        }
    }

    public final AbstractRelation execDmlCommand(DmlCommand dmlCommand) {
        this.jn();
        AbstractRelation abstractRelation = this.In.getSpecificationVersionForServer().isBefore(Version.ONE_FOUR) ? this.an(dmlCommand.getCommand()) : this.execDmlCommand(dmlCommand.getServerCommand());
        dmlCommand.ct();
        return abstractRelation;
    }

    public final AbstractRelation execDmlCommand(ServerCommand serverCommand) {
        this.jn();
        return this.f(serverCommand);
    }

    public final AbstractRelation execDmlCommand(String string) {
        this.jn();
        return this.an(string);
    }

    public final AbstractRelation execDmlCommandAndEndTransaction(DmlCommand dmlCommand) {
        try {
            AbstractRelation abstractRelation = this.execDmlCommand(dmlCommand.getCommand());
            dmlCommand.ct();
            this.end(true);
            return abstractRelation;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final AbstractRelation execDmlCommandAndEndTransaction(ServerCommand serverCommand) {
        try {
            AbstractRelation abstractRelation = this.execDmlCommand(serverCommand);
            this.end(true);
            return abstractRelation;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final AbstractRelation execDmlCommandAndEndTransaction(String string) {
        try {
            AbstractRelation abstractRelation = this.execDmlCommand(string);
            this.end(true);
            return abstractRelation;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final AbstractRelation execMultipleStatement(Collection collection) {
        boolean bl2 = true;
        String string = "";
        for (Object object : collection) {
            if (!(object instanceof DmlCommand)) {
                bl2 = false;
            }
            string = String.valueOf(string) + "CMD(" + object + ")";
        }
        if (string.length() > 0) {
            Object object;
            object = this.execDmlCommand(string);
            if (bl2) {
                for (DmlCommand dmlCommand : collection) {
                    dmlCommand.ct();
                }
            }
            return object;
        }
        return null;
    }

    public final AbstractRelation execMultipleStatement(DmlAssignmentCommand[] dmlAssignmentCommandArray) {
        int n2 = dmlAssignmentCommandArray.length;
        int n3 = 0;
        if (n2 > 0) {
            String string = "";
            while (n3 < n2) {
                string = String.valueOf(string) + "CMD(" + dmlAssignmentCommandArray[n3++].getCommand() + ")";
            }
            AbstractRelation abstractRelation = this.execDmlCommand(string);
            DmlAssignmentCommand[] dmlAssignmentCommandArray2 = dmlAssignmentCommandArray;
            int n4 = dmlAssignmentCommandArray.length;
            int n5 = 0;
            while (n5 < n4) {
                DmlAssignmentCommand dmlAssignmentCommand = dmlAssignmentCommandArray2[n5];
                dmlAssignmentCommand.ct();
                ++n5;
            }
            return abstractRelation;
        }
        return null;
    }

    public final AbstractRelation execMultipleStatement(String[] stringArray) {
        int n2 = stringArray.length;
        int n3 = 0;
        if (n2 > 0) {
            String string = "";
            while (n3 < n2) {
                string = String.valueOf(string) + "CMD(" + stringArray[n3++] + ")";
            }
            return this.execDmlCommand(string);
        }
        return null;
    }

    public final AbstractRelation execMultipleStatementAndEndTransaction(Collection collection) {
        try {
            AbstractRelation abstractRelation = this.execMultipleStatement(collection);
            this.end(true);
            return abstractRelation;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final AbstractRelation execMultipleStatementAndEndTransaction(DmlAssignmentCommand[] dmlAssignmentCommandArray) {
        try {
            AbstractRelation abstractRelation = this.execMultipleStatement(dmlAssignmentCommandArray);
            this.end(true);
            return abstractRelation;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final AbstractRelation execMultipleStatementAndEndTransaction(String[] stringArray) {
        try {
            AbstractRelation abstractRelation = this.execMultipleStatement(stringArray);
            this.end(true);
            return abstractRelation;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final AbstractRelation[] execQueries(String[] stringArray) {
        AbstractRelation[] abstractRelationArray = new AbstractRelation[stringArray.length];
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder("EXTEND(TABLE_DEE,(");
        n2 = 0;
        while (n2 < stringArray.length) {
            stringBuilder.append(Integer.toString(n2)).append('(').append(stringArray[n2]).append(')');
            ++n2;
        }
        stringBuilder.append(')').append(')');
        AbstractRelation abstractRelation = this.execQuery(stringBuilder.toString());
        n2 = 0;
        while (n2 < stringArray.length) {
            abstractRelationArray[n2] = ((Tuple)abstractRelation.iterator().next()).rvaValue(Integer.toString(n2));
            ++n2;
        }
        return abstractRelationArray;
    }

    public final AbstractRelation[] execQueriesAndEndTransaction(String[] stringArray) {
        try {
            AbstractRelation[] abstractRelationArray = this.execQueries(stringArray);
            this.end(true);
            return abstractRelationArray;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final AbstractRelation execQuery(String string) {
        return this.execDmlCommand("INQUIRE " + string);
    }

    public final AbstractRelation execQueryAndEndTransaction(String string) {
        try {
            AbstractRelation abstractRelation = this.execQuery(string);
            this.end(true);
            return abstractRelation;
        }
        catch (ErrorMessageException errorMessageException) {
            this.end(false);
            throw errorMessageException;
        }
        catch (RuntimeException runtimeException) {
            this.end(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.end(false);
            throw error;
        }
    }

    public final DBTransaction getParentTransaction() {
        return this.Ip;
    }

    public final long getTransactionID() {
        return this.oW;
    }

    public final boolean isAutoCommit() {
        return this.jW;
    }

    public final boolean isReadOnly() {
        return this.Iq.isReadOnly();
    }

    public final void rollback() {
        this.jn();
        if (!this.jW) {
            try {
                this.In.j(this.oW);
            }
            catch (ConnectionClosedException connectionClosedException) {
                this.In = null;
                throw connectionClosedException;
            }
        }
    }

    public final DBTransaction savePoint() {
        return this.startNestedTransaction(this.jW, this.isReadOnly());
    }

    public final DBTransaction startNestedTransaction(boolean bl2, boolean bl3) {
        if (this.Io == null) {
            try {
                this.Io = this.In.a(bl2, TransactionMode.getTransactionMode(bl3));
                return this.Io;
            }
            catch (ConnectionClosedException connectionClosedException) {
                this.In = null;
                throw connectionClosedException;
            }
        }
        return this.Io.startNestedTransaction(bl2, bl3);
    }

    public String toString() {
        return "Transaction " + super.toString() + "with server-side ID " + this.oW + " owned by " + this.iv + "on " + this.In;
    }
}

