/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.DuplicateException;
import be.SIRAPRISE.client.NonScalarTypeDeclaration;
import be.SIRAPRISE.client.ScalarTypeDeclaration;
import be.SIRAPRISE.client.TypeDeclaration;
import be.SIRAPRISE.client.TypeIsScalarException;
import be.SIRAPRISE.util.IntersectableLinkedHashMap;
import be.SIRAPRISE.util.IntersectableMap;
import be.SIRAPRISE.util.MyDataOutputStream;
import be.erwinsmout.NotFoundException;
import java.io.DataOutputStream;
import java.util.Map;
import java.util.Set;

public class Heading
extends IntersectableLinkedHashMap {
    @Override
    protected IntersectableMap cq() {
        Heading heading = new Heading();
        heading.putAll((Map)this);
        return heading;
    }

    public final void add(String string, Heading heading) {
        this.add(string, new NonScalarTypeDeclaration(heading));
    }

    public final void add(String string, String string2) {
        this.add(string, new ScalarTypeDeclaration(string2));
    }

    public final void add(String string, TypeDeclaration typeDeclaration) {
        if (this.containsKey(string)) {
            throw new DuplicateException(string);
        }
        this.put(string, typeDeclaration);
    }

    public final Set getAttributeNames() {
        return this.keySet();
    }

    public final Heading getHeading(String string) {
        if (this.containsKey(string)) {
            return ((TypeDeclaration)this.get(string)).getHeading();
        }
        throw new NotFoundException(string);
    }

    public final String getTypeName(String string) {
        if (this.containsKey(string)) {
            return ((TypeDeclaration)this.get(string)).getTypeName();
        }
        throw new NotFoundException(string);
    }

    public final boolean isStrictUnionCompatibleWith(Heading heading) {
        if (this.keySet().equals(heading.keySet())) {
            for (String string : this.keySet()) {
                try {
                    if (this.getTypeName(string).equals(heading.getTypeName(string))) continue;
                    return false;
                }
                catch (NotFoundException notFoundException) {
                    throw new RuntimeException(notFoundException);
                }
            }
            return true;
        }
        return false;
    }

    public final String print() {
        StringBuilder stringBuilder = new StringBuilder(60 * this.size());
        stringBuilder.append("HEADING(");
        for (Map.Entry entry : this.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = ((TypeDeclaration)entry.getValue()).getTypeName();
            stringBuilder.append(string).append('(').append(string2);
            if (string2.equalsIgnoreCase("RELATION")) {
                try {
                    stringBuilder.append('(').append(this.getHeading(string).print()).append(')');
                }
                catch (NotFoundException notFoundException) {
                    throw new RuntimeException(notFoundException);
                }
                catch (TypeIsScalarException typeIsScalarException) {
                    throw new RuntimeException(typeIsScalarException);
                }
            }
            stringBuilder.append(')');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public final String printXML() {
        StringBuilder stringBuilder = new StringBuilder(60 * this.size());
        stringBuilder.append("<Heading>");
        for (Map.Entry entry : this.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = ((TypeDeclaration)entry.getValue()).getTypeName();
            stringBuilder.append('<').append(string).append('>');
            if (string2.equalsIgnoreCase("RELATION")) {
                try {
                    stringBuilder.append("<Relation>").append(this.getHeading(string).printXML()).append("</Relation>");
                }
                catch (NotFoundException notFoundException) {
                    throw new RuntimeException(notFoundException);
                }
                catch (TypeIsScalarException typeIsScalarException) {
                    throw new RuntimeException(typeIsScalarException);
                }
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append("</").append(string).append('>');
        }
        stringBuilder.append("</Heading>");
        return stringBuilder.toString();
    }

    public final Heading subHeadingExcluding(Set set) {
        Heading heading;
        try {
            heading = (Heading)this.minus(set, Heading.class);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return heading;
    }

    public final Heading subHeadingIncluding(Set set) {
        Heading heading;
        try {
            heading = (Heading)this.intersect(set, Heading.class);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return heading;
    }

    public final void toStream1_0(DataOutputStream dataOutputStream) {
        dataOutputStream.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = ((TypeDeclaration)entry.getValue()).getTypeName();
            MyDataOutputStream.writeSmallUTF(string, dataOutputStream);
            MyDataOutputStream.writeSmallUTF(string2, dataOutputStream);
            if (!string2.equalsIgnoreCase("RELATION")) continue;
            try {
                this.getHeading(string).toStream1_0(dataOutputStream);
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException(notFoundException);
            }
            catch (TypeIsScalarException typeIsScalarException) {
                throw new RuntimeException(typeIsScalarException);
            }
        }
    }
}

