/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.IllegalServerCommandException;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.ServerAddCommand;
import be.SIRAPRISE.client.ServerAssertCommand;
import be.SIRAPRISE.client.ServerDeleteCommand;
import be.SIRAPRISE.client.ServerInquireCommand;
import be.SIRAPRISE.client.ServerMultipleAssignmentCommand;
import be.SIRAPRISE.client.ServerSingleAssignmentCommand;
import be.SIRAPRISE.client.ServerUnassertCommand;
import be.SIRAPRISE.client.ServerUpdateCommand;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NameValuePair;
import be.SIRAPRISE.util.NameValueResult;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.NotFoundException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class ServerCommand {
    private static final List td = Arrays.asList("ADD", "ASSERT", "DELETE", "UNASSERT", "UPDATE", "INQUIRE", "INSERT", "CREATE", "REMOVE", "MODIFY");

    private static ServerSingleAssignmentCommand G(String string) {
        ServerCommand serverCommand;
        try {
            serverCommand = ServerCommand.getCommandObjectFrom(string);
        }
        catch (NotFoundException notFoundException) {
            throw new IllegalServerCommandException(notFoundException);
        }
        if (!(serverCommand instanceof ServerSingleAssignmentCommand)) {
            throw new IllegalServerCommandException(Messages.getString("ServerCommand.IndividualAssignmentsOnly"));
        }
        return (ServerSingleAssignmentCommand)serverCommand;
    }

    public static ServerCommand getCommandObjectFor(String string, String string2) {
        int n2 = td.indexOf(string.toUpperCase());
        switch (n2) {
            case 0: 
            case 6: 
            case 7: {
                int n3 = string2.indexOf(44);
                if (n3 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{string2}));
                }
                String string3 = string2.substring(0, n3).trim();
                String string4 = string2.substring(n3 + 1).trim();
                if (string4.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{string2}));
                }
                return new ServerAddCommand(string3, string4);
            }
            case 1: {
                int n4 = string2.indexOf(44);
                if (n4 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{string2}));
                }
                String string5 = string2.substring(0, n4).trim();
                String string6 = string2.substring(n4 + 1).trim();
                if (string6.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{string2}));
                }
                return new ServerAssertCommand(string5, string6);
            }
            case 2: 
            case 8: {
                int n5 = string2.indexOf(44);
                if (n5 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{string2}));
                }
                String string7 = string2.substring(0, n5).trim();
                String string8 = string2.substring(n5 + 1).trim();
                if (string8.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{string2}));
                }
                return new ServerDeleteCommand(string7, string8);
            }
            case 3: {
                int n6 = string2.indexOf(44);
                if (n6 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{string2}));
                }
                String string9 = string2.substring(0, n6).trim();
                String string10 = string2.substring(n6 + 1).trim();
                if (string10.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{string2}));
                }
                return new ServerUnassertCommand(string9, string10);
            }
            case 4: 
            case 9: {
                String string11;
                String string12;
                int n7 = string2.indexOf(44);
                if (n7 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{string2}));
                }
                String string13 = string2.substring(0, n7).trim();
                String string14 = string2.substring(n7 + 1).trim();
                if (string14.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{string2}));
                }
                int n8 = string14.indexOf(44);
                if (n8 == 0) {
                    string14 = String.valueOf(string13) + string14;
                    n8 = string14.indexOf(44);
                }
                int n9 = string14.indexOf(40);
                if (n8 < 1 || n8 == string14.length() - 1 || n9 < 0) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.scalarExpressionsMissing"), new String[]{string14}));
                }
                if (n8 < n9) {
                    string12 = string14.substring(0, n8).trim();
                    string11 = string14.substring(n8 + 1).trim();
                } else {
                    try {
                        NameValueResult nameValueResult = BracketParser.getNameAndMandatoryValueFromEscaped(string14, 0);
                        string12 = string14.substring(0, nameValueResult.getNextParsePos());
                        string11 = string14.substring(nameValueResult.getNextParsePos()).trim();
                        if (string11.length() < 1 || string11.charAt(0) != ',') {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.scalarExpressionsMissing"), new String[]{string14}));
                        }
                        string11 = string11.substring(1).trim();
                    }
                    catch (NoOpeningBracketException noOpeningBracketException) {
                        throw new RuntimeException();
                    }
                    catch (NoClosingBracketException noClosingBracketException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.syntaxError"), new String[]{string14}), noClosingBracketException);
                    }
                    catch (InvalidEscapedCharacterException invalidEscapedCharacterException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.syntaxError"), new String[]{string14}), invalidEscapedCharacterException);
                    }
                    catch (MissingEscapedCharacterException missingEscapedCharacterException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.syntaxError"), new String[]{string14}), missingEscapedCharacterException);
                    }
                }
                return new ServerUpdateCommand(string13, string12, BracketParser.removeSuperfluousOuterBrackets(string11));
            }
            case 5: {
                LinkedList linkedList;
                String string15;
                String string16 = string2;
                int n10 = string16.indexOf(44);
                String string17 = "";
                if (n10 < 0) {
                    return new ServerInquireCommand(string2);
                }
                int n11 = string16.indexOf(40);
                if (n11 < 0) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.MissingParenthesesAroundOrderingSpec"), new String[]{string16.substring(n10 + 1)}));
                }
                if (n11 < n10) {
                    NameValueResult nameValueResult;
                    try {
                        nameValueResult = BracketParser.getNameAndMandatoryValueFromEscaped(string16, 0);
                    }
                    catch (NoOpeningBracketException noOpeningBracketException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string16}), noOpeningBracketException);
                    }
                    catch (NoClosingBracketException noClosingBracketException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string16}), noClosingBracketException);
                    }
                    catch (InvalidEscapedCharacterException invalidEscapedCharacterException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string16}), invalidEscapedCharacterException);
                    }
                    catch (MissingEscapedCharacterException missingEscapedCharacterException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string16}), missingEscapedCharacterException);
                    }
                    string15 = string16.substring(0, nameValueResult.getNextParsePos()).trim();
                    String string18 = string16.substring(nameValueResult.getNextParsePos()).trim();
                    if (string18.length() == 0) {
                        linkedList = new LinkedList();
                    } else {
                        if (!string18.startsWith(",")) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.MissingCommaBeforeOrderingSpec"), new String[]{string18}));
                        }
                        try {
                            NameValuePair nameValuePair = BracketParser.getNameAndMandatoryValueFromEscaped(string18, 0).getNameValuePair();
                            string17 = nameValuePair.getValue();
                            linkedList = RelationValueSelectorFactory.getNamesInEntryOrder(string17.toUpperCase());
                        }
                        catch (NoOpeningBracketException noOpeningBracketException) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string18}), noOpeningBracketException);
                        }
                        catch (NoClosingBracketException noClosingBracketException) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string18}), noClosingBracketException);
                        }
                        catch (InvalidEscapedCharacterException invalidEscapedCharacterException) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string18}), invalidEscapedCharacterException);
                        }
                        catch (MissingEscapedCharacterException missingEscapedCharacterException) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string18}), missingEscapedCharacterException);
                        }
                    }
                } else {
                    string15 = string16.substring(0, n10);
                    String string19 = string16.substring(n10 + 1);
                    try {
                        NameValuePair nameValuePair = BracketParser.getNameAndMandatoryValueFromEscaped(string19, 0).getNameValuePair();
                        string17 = nameValuePair.getValue();
                        linkedList = RelationValueSelectorFactory.getNamesInEntryOrder(string17.toUpperCase());
                    }
                    catch (NoOpeningBracketException noOpeningBracketException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string19}), noOpeningBracketException);
                    }
                    catch (NoClosingBracketException noClosingBracketException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string19}), noClosingBracketException);
                    }
                    catch (InvalidEscapedCharacterException invalidEscapedCharacterException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string19}), invalidEscapedCharacterException);
                    }
                    catch (MissingEscapedCharacterException missingEscapedCharacterException) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{string19}), missingEscapedCharacterException);
                    }
                }
                return new ServerInquireCommand(string15, linkedList);
            }
        }
        throw new NotFoundException(MyMessageFormat.format(Messages.getString("ServerCommand.invalidCommand"), new String[]{td.toString(), string}));
    }

    public static ServerCommand getCommandObjectFrom(String string) {
        String string2;
        String string3;
        if (string.length() > 2 && string.substring(0, 3).equalsIgnoreCase("CMD")) {
            LinkedList linkedList;
            try {
                linkedList = BracketParser.createListFromEscaped(string);
            }
            catch (NoClosingBracketException noClosingBracketException) {
                throw new IllegalServerCommandException(string, noClosingBracketException);
            }
            catch (InvalidEscapedCharacterException invalidEscapedCharacterException) {
                throw new IllegalServerCommandException(string, invalidEscapedCharacterException);
            }
            catch (MissingEscapedCharacterException missingEscapedCharacterException) {
                throw new IllegalServerCommandException(string, missingEscapedCharacterException);
            }
            catch (NoOpeningBracketException noOpeningBracketException) {
                throw new IllegalServerCommandException(string, noOpeningBracketException);
            }
            int n2 = 0;
            ServerSingleAssignmentCommand[] serverSingleAssignmentCommandArray = new ServerSingleAssignmentCommand[linkedList.size()];
            for (String string4 : linkedList) {
                serverSingleAssignmentCommandArray[n2++] = ServerCommand.G(string4);
            }
            if (serverSingleAssignmentCommandArray.length == 1) {
                return serverSingleAssignmentCommandArray[0];
            }
            return new ServerMultipleAssignmentCommand(serverSingleAssignmentCommandArray);
        }
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n3).trim();
            string2 = string.substring(n3 + 1).trim();
        }
        return ServerCommand.getCommandObjectFor(string3, string2);
    }

    public abstract String getFullCommandText();

    public abstract String getCommandParametersText();

    abstract int G();

    public String toString() {
        return this.getFullCommandText();
    }
}

