/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.Messages;

public class Version
implements Comparable {
    public static final Version ONE_FOUR = new Version(1, 4);
    public static final Version ONE_ONE = new Version(1, 1);
    public static final Version ONE_THREE = new Version(1, 3);
    public static final Version ONE_TWO = new Version(1, 2);
    public static final Version ONE_ZERO = new Version(1, 0);
    private short xQ;
    private short xR;

    public Version(int n2) {
        this((short)(n2 >>> 16), (short)(n2 & 0xFFFF));
    }

    public Version(short s2, short s3) {
        if (s2 < 1 || s3 < 0) {
            throw new IllegalArgumentException(Messages.getString("Version.NegativeComponent"));
        }
        this.xQ = s2;
        this.xR = s3;
    }

    public final int compareTo(Version version) {
        if (this.equals(version)) {
            return 0;
        }
        if (this.isBefore(version)) {
            return -1;
        }
        return 1;
    }

    public final boolean equals(Object object) {
        if (object instanceof Version) {
            Version version = (Version)object;
            return version.xQ == this.xQ && version.xR == this.xR;
        }
        return false;
    }

    public final int getFullVersion() {
        return this.xQ << 16 | this.xR;
    }

    public final Version getLowest(Version version) {
        if (this.isBefore(version)) {
            return this;
        }
        return version;
    }

    public final short getMajorVersion() {
        return this.xQ;
    }

    public final short getMinorVersion() {
        return this.xR;
    }

    public final int hashCode() {
        return this.getFullVersion();
    }

    public final boolean isAtLeast(short s2, short s3) {
        return this.xQ > s2 || this.xQ == s2 && this.xR >= s3;
    }

    public final boolean isAtLeast(Version version) {
        return this.xQ > version.xQ || this.xQ == version.xQ && this.xR >= version.xR;
    }

    public final boolean isBefore(short s2, short s3) {
        return this.xQ < s2 || this.xQ == s2 && this.xR < s3;
    }

    public final boolean isBefore(Version version) {
        return this.xQ < version.xQ || this.xQ == version.xQ && this.xR < version.xR;
    }

    public final String toString() {
        return String.valueOf(Integer.toString(this.xQ)) + '.' + Integer.toString(this.xR);
    }
}

