/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.Messages;
import be.SIRAPRISE.messages.ServerHelloMessage;
import be.SIRAPRISE.messages.ServerHelloMessageType;
import be.SIRAPRISE.messages.ServerHelloMessageV1_0;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.ServerMessageType;
import be.SIRAPRISE.security.JCECipher;
import be.SIRAPRISE.security.ProprietaryOrJCECipher;
import be.SIRAPRISE.security.SPE;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public final class ServerHelloMessageTypeV1_0
extends ServerHelloMessageType {
    private static final ServerMessageType r = new ServerHelloMessageTypeV1_0();

    static ServerMessageType m() {
        return r;
    }

    private ServerHelloMessageTypeV1_0() {
        super(Version.ONE_ZERO, Version.ONE_ZERO);
    }

    @Override
    ServerMessage a(DataInputStream dataInputStream) {
        byte by2;
        Signature signature = null;
        ProprietaryOrJCECipher proprietaryOrJCECipher = null;
        byte by3 = dataInputStream.readByte();
        if (by3 != 0) {
            String string = MyDataInputStream.getSmallUTFString(dataInputStream);
            try {
                signature = Signature.getInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(Messages.getString("ServerHelloMessageTypeV1_0.SignatureProtocolCriticalFailure"));
            }
        }
        if ((by2 = dataInputStream.readByte()) != 0) {
            String string = MyDataInputStream.getSmallUTFString(dataInputStream);
            try {
                proprietaryOrJCECipher = new JCECipher(Cipher.getInstance(string));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (string.equalsIgnoreCase("SPE")) {
                    proprietaryOrJCECipher = new SPE();
                }
                throw new IOException(Messages.getString("ServerHelloMessageTypeV1_0.EncryptionProtocolCriticalFailure"));
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new IOException(Messages.getString("ServerHelloMessageTypeV1_0.EncryptionProtocolCriticalFailure"));
            }
            ((ProprietaryOrJCECipher)proprietaryOrJCECipher).getPublishedKey(dataInputStream);
        }
        long l2 = dataInputStream.readLong();
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n2 = dataInputStream.readShort();
        while (n2-- > 0) {
            String string = MyDataInputStream.getSmallUTFString(dataInputStream);
            linkedHashSet.add(string);
        }
        return new ServerHelloMessageV1_0(this, signature, proprietaryOrJCECipher, l2, new Version(s2, s3), linkedHashSet);
    }

    @Override
    void a(ServerMessage serverMessage, DataOutputStream dataOutputStream) {
        if (!(serverMessage instanceof ServerHelloMessageV1_0)) {
            throw new IllegalArgumentException();
        }
        ServerHelloMessageV1_0 serverHelloMessageV1_0 = (ServerHelloMessageV1_0)serverMessage;
        Signature signature = serverHelloMessageV1_0.getSigningProtocol();
        if (signature == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            MyDataOutputStream.writeSmallUTF(signature.getAlgorithm(), dataOutputStream);
        }
        ProprietaryOrJCECipher proprietaryOrJCECipher = serverHelloMessageV1_0.getCryptoProtocol();
        if (proprietaryOrJCECipher == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            MyDataOutputStream.writeSmallUTF(proprietaryOrJCECipher.getAlgorithm(), dataOutputStream);
            proprietaryOrJCECipher.publishKey(dataOutputStream);
        }
        dataOutputStream.writeLong(serverHelloMessageV1_0.getIdleTime());
        dataOutputStream.writeShort(serverHelloMessageV1_0.getVersion().getMajorVersion());
        dataOutputStream.writeShort(serverHelloMessageV1_0.getVersion().getMinorVersion());
        Set set = serverHelloMessageV1_0.getAlternativeSigningProtocols();
        dataOutputStream.writeShort(set.size());
        for (String string : set) {
            MyDataOutputStream.writeSmallUTF(string, dataOutputStream);
        }
    }

    @Override
    public ServerHelloMessage message(Signature signature, ProprietaryOrJCECipher proprietaryOrJCECipher, long l2, Version version, Set set) {
        return new ServerHelloMessageV1_0(this, signature, proprietaryOrJCECipher, l2, version, set);
    }
}

