/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.CommunicationProtocolException;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.messages.ErrorMessageType;
import be.SIRAPRISE.messages.Messages;
import be.SIRAPRISE.messages.ServerErrorMessage;
import be.SIRAPRISE.messages.ServerMessageType;
import be.SIRAPRISE.messages.ServerMessageTypes;
import be.SIRAPRISE.security.ProprietaryOrJCECipher;
import be.SIRAPRISE.util.MyDataInputStream;
import be.erwinsmout.NotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public abstract class ServerMessage {
    private ServerMessageType GA;

    public static ServerMessage readMessage(DataInputStream dataInputStream, ProprietaryOrJCECipher proprietaryOrJCECipher, Signature signature, PublicKey publicKey) {
        ServerMessageType serverMessageType;
        Object object;
        int n2;
        int n3 = 0;
        n3 = dataInputStream.readInt();
        if (n3 < 0) {
            throw new IOException(Messages.getString("ServerMessage.NegativeByteCount"));
        }
        byte[] byArray = MyDataInputStream.readExactNumberOfBytes(dataInputStream, n3);
        if (proprietaryOrJCECipher != null) {
            try {
                byArray = proprietaryOrJCECipher.decrypt(byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.DecryptionFailed"), invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.DecryptionFailed"), illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.DecryptionFailed"), badPaddingException);
            }
        }
        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
        if (signature != null) {
            try {
                n2 = dataInputStream2.readShort();
                byte[] byArray2 = new byte[n2];
                dataInputStream2.read(byArray2);
                int n4 = dataInputStream2.readInt();
                object = MyDataInputStream.readExactNumberOfBytes(dataInputStream2, n4);
                dataInputStream2 = new DataInputStream(new ByteArrayInputStream((byte[])object));
                signature.initVerify(publicKey);
                signature.update((byte[])object);
                if (!signature.verify(byArray2)) {
                    throw new CommunicationProtocolException(Messages.getString("ServerMessage.VerificationFailed"), null);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.VerificationFailed"), invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessage.VerificationFailed"), signatureException);
            }
        }
        n2 = dataInputStream2.readInt();
        int n5 = dataInputStream2.readInt();
        try {
            serverMessageType = ServerMessageTypes.getInstance().getServerMessageTypeForMessageVersion(n2, n5);
        }
        catch (NotFoundException notFoundException) {
            throw new CommunicationProtocolException(n2, n5);
        }
        object = serverMessageType.a(dataInputStream2);
        if (serverMessageType instanceof ErrorMessageType) {
            throw new ErrorMessageException((ServerErrorMessage)object);
        }
        return object;
    }

    ServerMessage(ServerMessageType serverMessageType) {
        this.GA = serverMessageType;
    }

    public final int getMessageTypeID() {
        return this.GA.getMessageTypeID();
    }

    public final void sendMessage(DataOutputStream dataOutputStream, Signature signature, Signer signer, ProprietaryOrJCECipher proprietaryOrJCECipher) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(256);
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
        dataOutputStream2.writeInt(this.GA.getMessageTypeID());
        dataOutputStream2.writeShort(this.GA.getMajorVersion());
        dataOutputStream2.writeShort(this.GA.getMinorVersion());
        this.GA.a(this, dataOutputStream2);
        if (signature != null) {
            byteArrayOutputStream = new ByteArrayOutputStream(byteArrayOutputStream2.size());
            try {
                object = byteArrayOutputStream2.toByteArray();
                byte[] byArray = signer.sign(signature, (byte[])object);
                DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream3.writeShort(byArray.length);
                dataOutputStream3.write(byArray);
                dataOutputStream3.writeInt(byteArrayOutputStream2.size());
                dataOutputStream3.write((byte[])object);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.SigningFailed"), invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.SigningFailed"), signatureException);
            }
            catch (NotFoundException notFoundException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.SigningFailed"), notFoundException);
            }
        } else {
            byteArrayOutputStream = byteArrayOutputStream2;
        }
        if (proprietaryOrJCECipher != null) {
            object = new ByteArrayOutputStream();
            try {
                ((OutputStream)object).write(proprietaryOrJCECipher.encrypt(byteArrayOutputStream.toByteArray()));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.EncryptionFailed"), invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.EncryptionFailed"), illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                throw new CommunicationProtocolException(Messages.getString("ServerMessageType.EncryptionFailed"), badPaddingException);
            }
        } else {
            object = byteArrayOutputStream;
        }
        dataOutputStream.writeInt(((ByteArrayOutputStream)object).size());
        ((ByteArrayOutputStream)object).writeTo(dataOutputStream);
        dataOutputStream.flush();
    }
}

