/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.security;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SpsSignatureImplementation
extends SignatureSpi {
    private RSAPrivateKey Ch;
    private RSAPublicKey Ci;
    private MessageDigest Cj;

    @Override
    protected Object engineGetParameter(String string) {
        throw new InvalidParameterException();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        try {
            if (this.Cj == null) {
                this.Cj = MessageDigest.getInstance("SPMD");
            } else {
                this.Cj.reset();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException();
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.Ch = (RSAPrivateKey)privateKey;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        try {
            if (this.Cj == null) {
                this.Cj = MessageDigest.getInstance("SPMD");
            } else {
                this.Cj.reset();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException();
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.Ci = (RSAPublicKey)publicKey;
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new InvalidParameterException();
    }

    @Override
    protected byte[] engineSign() {
        byte[] byArray = this.Cj.digest();
        BigInteger bigInteger = new BigInteger(byArray);
        BigInteger bigInteger2 = bigInteger.modPow(this.Ch.getPrivateExponent(), this.Ch.getModulus());
        return bigInteger2.toByteArray();
    }

    @Override
    protected void engineUpdate(byte by2) {
        this.Cj.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.Cj.update(byArray, n2, n3);
    }

    @Override
    protected boolean engineVerify(byte[] byArray) {
        byte[] byArray2 = this.Cj.digest();
        BigInteger bigInteger = new BigInteger(byArray2);
        BigInteger bigInteger2 = new BigInteger(byArray);
        BigInteger bigInteger3 = bigInteger2.modPow(this.Ci.getPublicExponent(), this.Ci.getModulus());
        return bigInteger3.equals(bigInteger);
    }
}

