/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.typeimplementations;

import be.SIRAPRISE.typeimplementations.DbmsStringImplementation;
import be.SIRAPRISE.typeimplementations.InvalidValueException;
import be.SIRAPRISE.typeimplementations.Messages;
import be.SIRAPRISE.typeimplementations.PossRepImplementation;
import be.SIRAPRISE.typeimplementations.ScalarValueBuffer;
import be.SIRAPRISE.typeimplementations.TypeImplementation;
import be.SIRAPRISE.typeimplementations.ValueBuffer;
import be.SIRAPRISE.util.MyReadOnlyMap;
import be.SIRAPRISE.util.MyReadOnlySet;
import be.erwinsmout.MyMessageFormat;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DbmsFloatImplementation
implements PossRepImplementation,
TypeImplementation {
    private static DbmsFloatImplementation he = new DbmsFloatImplementation();
    private Map hf = this.ar();
    private Set hg = new MyReadOnlySet(new HashSet<PossRepImplementation>(Arrays.asList(this)));
    private Map hh = this.as();

    public static DbmsFloatImplementation getInstance() {
        return he;
    }

    public static double getJavaDouble(ValueBuffer valueBuffer) {
        return ((ScalarValueBuffer)valueBuffer).getByteBuffer().getDouble();
    }

    public static ScalarValueBuffer getValueBuffer(double d2) {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException(Messages.getString("DbmsFloatImplementation.NotANumber"));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        if (d2 == 0.0) {
            byteBuffer.putDouble(0.0);
        } else {
            byteBuffer.putDouble(d2);
        }
        return new ScalarValueBuffer(byteBuffer);
    }

    private DbmsFloatImplementation() {
    }

    private MyReadOnlyMap ar() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("STRING", "STRING");
        return new MyReadOnlyMap(hashMap);
    }

    private MyReadOnlyMap as() {
        HashMap<String, PossRepImplementation> hashMap = new HashMap<String, PossRepImplementation>();
        for (PossRepImplementation possRepImplementation : this.hg) {
            for (String string : possRepImplementation.getComponentNameMap().keySet()) {
                hashMap.put(string, possRepImplementation);
            }
        }
        return new MyReadOnlyMap(hashMap);
    }

    @Override
    public Map getComponentNameMap() {
        return this.hf;
    }

    @Override
    public ValueBuffer getComponentValue(String string, ScalarValueBuffer scalarValueBuffer) {
        try {
            return DbmsStringImplementation.getValueBuffer(this.valueToExternalRepresentation(scalarValueBuffer));
        }
        catch (InvalidValueException invalidValueException) {
            throw new RuntimeException(invalidValueException);
        }
    }

    @Override
    public PossRepImplementation getDefaultPossrepImplementation() {
        return this;
    }

    @Override
    public int getDfltLogicalSize() {
        return 1;
    }

    @Override
    public int getMaxLogicalSize() {
        return 1;
    }

    @Override
    public int getMinLogicalSize() {
        return 1;
    }

    @Override
    public int getPhysicalSizeFor(int n2) {
        return 8;
    }

    @Override
    public PossRepImplementation getPossrepImplementation(String string) {
        PossRepImplementation possRepImplementation = (PossRepImplementation)this.hh.get(string);
        if (possRepImplementation == null) {
            throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("IntervalTypeImplementation.UnknownCompoenent"), new String[]{string, this.getClass().getName()}));
        }
        return possRepImplementation;
    }

    @Override
    public Set getPossrepImplementations() {
        return this.hg;
    }

    @Override
    public String getPossrepName() {
        return "FLOAT";
    }

    @Override
    public ValueBuffer valueFromComponentValues(HashMap hashMap, int n2) {
        return this.valueFromExternalRepresentation(DbmsStringImplementation.getJavaString((ScalarValueBuffer)hashMap.get("STRING")));
    }

    @Override
    public ValueBuffer valueFromExternalRepresentation(String string) {
        double d2;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsFloatImplementation.Value"), new String[]{string}));
        }
        return DbmsFloatImplementation.getValueBuffer(d2);
    }

    @Override
    public ValueBuffer valueFromExternalRepresentation(String string, int n2) {
        return this.valueFromExternalRepresentation(string);
    }

    @Override
    public String valueToEscapedExternalRepresentation(ValueBuffer valueBuffer) {
        return this.valueToExternalRepresentation(valueBuffer);
    }

    @Override
    public String valueToExternalRepresentation(ValueBuffer valueBuffer) {
        return Double.toString(DbmsFloatImplementation.getJavaDouble(valueBuffer));
    }
}

