/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.util.BracketParseResult;
import be.SIRAPRISE.util.DuplicateNameException;
import be.SIRAPRISE.util.IntersectableHashMap;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NameValuePair;
import be.SIRAPRISE.util.NameValueResult;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class BracketParser {
    private static boolean Y(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            try {
                return BracketParser.findCorrespondingClosingBracket(string) == string.length() - 1;
            }
            catch (NoClosingBracketException noClosingBracketException) {
                return false;
            }
        }
        return false;
    }

    public static LinkedList createListFromEscaped(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        while (n2 < string.length()) {
            NameValueResult nameValueResult = BracketParser.getNameAndMandatoryValueFromEscaped(string, n2);
            NameValuePair nameValuePair = nameValueResult.getNameValuePair();
            String string2 = nameValuePair.getValue();
            linkedList.add(string2);
            n2 = nameValueResult.getNextParsePos();
        }
        return linkedList;
    }

    public static LinkedList createListFromNonEscaped(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        while (n2 < string.length()) {
            NameValueResult nameValueResult = BracketParser.getNameAndMandatoryValueFromNonEscaped(string, n2);
            NameValuePair nameValuePair = nameValueResult.getNameValuePair();
            String string2 = nameValuePair.getValue();
            linkedList.add(string2);
            n2 = nameValueResult.getNextParsePos();
        }
        return linkedList;
    }

    public static HashMap createMapFromEscaped(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < string.length()) {
            NameValueResult nameValueResult = BracketParser.getNameValueFromEscaped(string, n2);
            NameValuePair nameValuePair = nameValueResult.getNameValuePair();
            String string2 = nameValuePair.getName();
            String string3 = nameValuePair.getValue();
            if (hashMap.containsKey(string2)) {
                throw new DuplicateNameException(string2);
            }
            hashMap.put(string2, string3);
            n2 = nameValueResult.getNextParsePos();
        }
        return hashMap;
    }

    public static HashMap createMapFromNonEscaped(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < string.length()) {
            NameValueResult nameValueResult = BracketParser.getNameValueFromNonEscaped(string, n2);
            NameValuePair nameValuePair = nameValueResult.getNameValuePair();
            String string2 = nameValuePair.getName();
            String string3 = nameValuePair.getValue();
            if (hashMap.containsKey(string2)) {
                throw new DuplicateNameException(string2);
            }
            hashMap.put(string2, string3);
            n2 = nameValueResult.getNextParsePos();
        }
        return hashMap;
    }

    public static HashMap createMapWithMandatoryValuesFromEscaped(String string) {
        HashMap hashMap = new HashMap();
        BracketParser.fillMapWithMandatoryValuesFromEscaped(string, hashMap);
        return hashMap;
    }

    public static HashMap createMapWithMandatoryValuesFromNonEscaped(String string) {
        HashMap hashMap = new HashMap();
        BracketParser.fillMapWithMandatoryValuesFromNonEscaped(string, hashMap);
        return hashMap;
    }

    public static void fillMapWithMandatoryValuesFromEscaped(String string, Map map) {
        int n2 = 0;
        while (n2 < string.length()) {
            NameValueResult nameValueResult = BracketParser.getNameAndMandatoryValueFromEscaped(string, n2);
            NameValuePair nameValuePair = nameValueResult.getNameValuePair();
            String string2 = nameValuePair.getName();
            String string3 = nameValuePair.getValue();
            if (map.containsKey(string2)) {
                throw new DuplicateNameException(string2);
            }
            map.put(string2, string3);
            n2 = nameValueResult.getNextParsePos();
        }
    }

    public static void fillMapWithMandatoryValuesFromNonEscaped(String string, Map map) {
        int n2 = 0;
        while (n2 < string.length()) {
            NameValueResult nameValueResult = BracketParser.getNameAndMandatoryValueFromNonEscaped(string, n2);
            NameValuePair nameValuePair = nameValueResult.getNameValuePair();
            String string2 = nameValuePair.getName();
            String string3 = nameValuePair.getValue();
            if (map.containsKey(string2)) {
                throw new DuplicateNameException(string2);
            }
            map.put(string2, string3);
            n2 = nameValueResult.getNextParsePos();
        }
    }

    public static void fillNonEmptyMapWithMandatoryValuesFromEscaped(String string, Map map) {
        BracketParser.fillMapWithMandatoryValuesFromEscaped(string, map);
        if (map.size() < 1) {
            throw new IllegalArgumentException("Empty map not allowed from " + string);
        }
    }

    public static void fillNonEmptyMapWithMandatoryValuesFromNonEscaped(String string, Map map) {
        BracketParser.fillMapWithMandatoryValuesFromNonEscaped(string, map);
        if (map.size() < 1) {
            throw new IllegalArgumentException("Empty map not allowed from " + string);
        }
    }

    public static int findCorrespondingClosingBracket(String string) {
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        do {
            char c2 = string.charAt(n2);
            if (bl2) {
                bl2 = false;
                continue;
            }
            if (c2 == '\\') {
                bl2 = true;
                continue;
            }
            if (c2 == '(') {
                ++n3;
                continue;
            }
            if (c2 != ')') continue;
            --n3;
        } while (n3 != 0 && ++n2 < string.length());
        if (n2 == 0 || n3 != 0) {
            throw new NoClosingBracketException(string);
        }
        return n2;
    }

    public static NameValueResult getNameAndMandatoryValueFromEscaped(String string, int n2) {
        int n3 = Math.max(0, n2);
        int n4 = string.length();
        boolean bl2 = false;
        boolean bl3 = true;
        block15: while (n3 < n4 && bl3) {
            if (bl2) {
                switch (string.charAt(n3)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        bl2 = false;
                        ++n3;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(n3, string.charAt(n3));
                    }
                }
            }
            switch (string.charAt(n3)) {
                case '(': {
                    bl3 = false;
                    break;
                }
                case '\\': {
                    bl2 = true;
                    ++n3;
                    break;
                }
                default: {
                    ++n3;
                }
            }
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (bl3) {
            throw new NoOpeningBracketException(string.substring(n2));
        }
        String string2 = string.substring(n2, n3).trim();
        bl3 = true;
        int n5 = 1;
        int n6 = ++n3;
        while (n5 > 0 && n3 < n4) {
            block23: {
                block22: {
                    if (!bl2) break block22;
                    switch (string.charAt(n3)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            bl2 = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(n3, string.charAt(n3));
                        }
                    }
                }
                switch (string.charAt(n3)) {
                    case ')': {
                        --n5;
                        break;
                    }
                    case '(': {
                        ++n5;
                        break;
                    }
                    case '\\': {
                        bl2 = true;
                    }
                }
            }
            ++n3;
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (n5 > 0) {
            throw new NoClosingBracketException(string.substring(n2));
        }
        return new NameValueResult(n2, --n3, new NameValuePair(string2, string.substring(n6, n3)));
    }

    public static NameValueResult getNameAndMandatoryValueFromNonEscaped(String string, int n2) {
        int n3 = Math.max(0, n2);
        int n4 = string.length();
        boolean bl2 = true;
        while (n3 < n4 && bl2) {
            switch (string.charAt(n3)) {
                case '(': {
                    bl2 = false;
                    break;
                }
                default: {
                    ++n3;
                }
            }
        }
        if (bl2) {
            throw new NoOpeningBracketException(string.substring(n2));
        }
        String string2 = string.substring(n2, n3).trim();
        bl2 = true;
        int n5 = 1;
        int n6 = ++n3;
        while (n5 > 0 && n3 < n4) {
            switch (string.charAt(n3)) {
                case ')': {
                    --n5;
                    break;
                }
                case '(': {
                    ++n5;
                }
            }
            ++n3;
        }
        if (n5 > 0) {
            throw new NoClosingBracketException(string.substring(n2));
        }
        return new NameValueResult(n2, --n3, new NameValuePair(string2, string.substring(n6, n3)));
    }

    public static NameValueResult getNameAndMandatoryValueUntrimmedFromEscaped(String string, int n2) {
        int n3 = 0;
        int n4 = Math.max(0, n2);
        int n5 = string.length();
        boolean bl2 = false;
        boolean bl3 = true;
        block15: while (n4 < n5 && bl3) {
            if (bl2) {
                switch (string.charAt(n4)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        bl2 = false;
                        ++n4;
                        ++n3;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(n4, string.charAt(n4));
                    }
                }
            }
            switch (string.charAt(n4)) {
                case '(': {
                    bl3 = false;
                    break;
                }
                case '\\': {
                    bl2 = true;
                    ++n4;
                    ++n3;
                    break;
                }
                default: {
                    ++n4;
                    ++n3;
                }
            }
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (bl3) {
            throw new NoOpeningBracketException(string.substring(n2));
        }
        String string2 = string.substring(n2, n4).trim();
        bl3 = true;
        int n6 = 1;
        ++n4;
        int n7 = ++n3;
        while (n6 > 0 && n4 < n5) {
            block23: {
                block22: {
                    if (!bl2) break block22;
                    switch (string.charAt(n4)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            bl2 = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(n4, string.charAt(n4));
                        }
                    }
                }
                switch (string.charAt(n4)) {
                    case ')': {
                        --n6;
                        break;
                    }
                    case '(': {
                        ++n6;
                        break;
                    }
                    case '\\': {
                        bl2 = true;
                    }
                }
            }
            ++n4;
            ++n3;
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (n6 > 0) {
            throw new NoClosingBracketException(string.substring(n2));
        }
        --n3;
        return new NameValueResult(n2, --n4, new NameValuePair(string2, string.substring(n7, n4)));
    }

    public static BracketParseResult getNameBeforeBracket(String string) {
        int n2 = string.indexOf(40);
        if (n2 < 0) {
            throw new NoOpeningBracketException(string);
        }
        return new BracketParseResult(string.substring(0, n2).trim().toUpperCase(), n2);
    }

    public static NameValueResult getNameValueFromEscaped(String string, int n2) {
        int n3 = Math.max(0, n2);
        int n4 = string.length();
        boolean bl2 = false;
        boolean bl3 = true;
        block15: while (n3 < n4 && bl3) {
            if (bl2) {
                switch (string.charAt(n3)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        bl2 = false;
                        ++n3;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(n3, string.charAt(n3));
                    }
                }
            }
            switch (string.charAt(n3)) {
                case '(': {
                    bl3 = false;
                    break;
                }
                case '\\': {
                    bl2 = true;
                    ++n3;
                    break;
                }
                default: {
                    ++n3;
                }
            }
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (bl3) {
            String string2 = string.substring(n2).trim();
            return new NameValueResult(n2, n3, new NameValuePair(string2, ""));
        }
        String string3 = string.substring(n2, n3).trim();
        bl3 = true;
        int n5 = 1;
        int n6 = ++n3;
        while (n5 > 0 && n3 < n4) {
            block23: {
                block22: {
                    if (!bl2) break block22;
                    switch (string.charAt(n3)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            bl2 = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(n3, string.charAt(n3));
                        }
                    }
                }
                switch (string.charAt(n3)) {
                    case ')': {
                        --n5;
                        break;
                    }
                    case '(': {
                        ++n5;
                        break;
                    }
                    case '\\': {
                        bl2 = true;
                    }
                }
            }
            ++n3;
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (n5 > 0) {
            throw new NoClosingBracketException(string.substring(n2));
        }
        return new NameValueResult(n2, --n3, new NameValuePair(new String(string3), string.substring(n6, n3).trim()));
    }

    public static NameValueResult getNameValueFromNonEscaped(String string, int n2) {
        int n3 = Math.max(0, n2);
        int n4 = string.length();
        boolean bl2 = true;
        while (n3 < n4 && bl2) {
            switch (string.charAt(n3)) {
                case '(': {
                    bl2 = false;
                    break;
                }
                default: {
                    ++n3;
                }
            }
        }
        if (bl2) {
            String string2 = string.substring(n2).trim();
            return new NameValueResult(n2, n3, new NameValuePair(string2, ""));
        }
        String string3 = string.substring(n2, n3).trim();
        bl2 = true;
        int n5 = 1;
        int n6 = ++n3;
        while (n5 > 0 && n3 < n4) {
            switch (string.charAt(n3)) {
                case ')': {
                    --n5;
                    break;
                }
                case '(': {
                    ++n5;
                }
            }
            ++n3;
        }
        if (n5 > 0) {
            throw new NoClosingBracketException(string.substring(n2));
        }
        return new NameValueResult(n2, --n3, new NameValuePair(string3, string.substring(n6, n3).trim()));
    }

    public static NameValueResult getNameValueUntrimmedFromEscaped(String string, int n2) {
        int n3 = Math.max(0, n2);
        int n4 = string.length();
        boolean bl2 = false;
        boolean bl3 = true;
        block15: while (n3 < n4 && bl3) {
            if (bl2) {
                switch (string.charAt(n3)) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        bl2 = false;
                        ++n3;
                        continue block15;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(n3, string.charAt(n3));
                    }
                }
            }
            switch (string.charAt(n3)) {
                case '(': {
                    bl3 = false;
                    break;
                }
                case '\\': {
                    bl2 = true;
                    ++n3;
                    break;
                }
                default: {
                    ++n3;
                }
            }
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (bl3) {
            String string2 = string.substring(n2).trim();
            return new NameValueResult(n2, n3, new NameValuePair(string2, ""));
        }
        String string3 = string.substring(n2, n3).trim();
        bl3 = true;
        int n5 = 1;
        int n6 = ++n3;
        while (n5 > 0 && n3 < n4) {
            block23: {
                block22: {
                    if (!bl2) break block22;
                    switch (string.charAt(n3)) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            bl2 = false;
                            break block23;
                        }
                        default: {
                            throw new InvalidEscapedCharacterException(n3, string.charAt(n3));
                        }
                    }
                }
                switch (string.charAt(n3)) {
                    case ')': {
                        --n5;
                        break;
                    }
                    case '(': {
                        ++n5;
                        break;
                    }
                    case '\\': {
                        bl2 = true;
                    }
                }
            }
            ++n3;
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        if (n5 > 0) {
            throw new NoClosingBracketException(string.substring(n2));
        }
        return new NameValueResult(n2, --n3, new NameValuePair(string3, string.substring(n6, n3)));
    }

    public static BracketParseResult getUnMetaContentsWithinBrackets(String string) {
        int n2 = string.indexOf(40);
        if (n2 == -1) {
            throw new NoOpeningBracketException(string);
        }
        String string2 = string.substring(n2);
        int n3 = BracketParser.findCorrespondingClosingBracket(string2);
        String string3 = string2.substring(1, n3).trim();
        return new BracketParseResult(BracketParser.unMeta(string3), n2 + n3 + 1);
    }

    public static BracketParseResult getUnMetaContentsWithinBracketsUntrimmed(String string) {
        int n2 = string.indexOf(40);
        if (n2 == -1) {
            throw new NoOpeningBracketException(string);
        }
        String string2 = string.substring(n2);
        int n3 = BracketParser.findCorrespondingClosingBracket(string2);
        String string3 = string2.substring(1, n3);
        return new BracketParseResult(BracketParser.unMeta(string3), n2 + n3 + 1);
    }

    public static String meta(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + (n2 >>> 3));
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3++);
            switch (c2) {
                case '(': {
                    stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer.append("\\)");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String removeSuperfluousOuterBrackets(String string) {
        String string2 = string;
        while (BracketParser.Y(string2)) {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        return string2;
    }

    public static String unMeta(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        boolean bl2 = false;
        block6: while (n3 < n2) {
            char c2 = string.charAt(n3++);
            if (bl2) {
                switch (c2) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        stringBuffer.append(c2);
                        bl2 = false;
                        continue block6;
                    }
                    default: {
                        throw new InvalidEscapedCharacterException(n3, string.charAt(n3));
                    }
                }
            }
            switch (c2) {
                case '\\': {
                    bl2 = true;
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        if (bl2) {
            throw new MissingEscapedCharacterException();
        }
        return stringBuffer.toString();
    }

    public static String unMetaWithoutException(String string) {
        try {
            return BracketParser.unMeta(string);
        }
        catch (InvalidEscapedCharacterException invalidEscapedCharacterException) {
            throw new IllegalArgumentException(String.valueOf(string) + ":\n" + invalidEscapedCharacterException.getMessage());
        }
        catch (MissingEscapedCharacterException missingEscapedCharacterException) {
            throw new IllegalArgumentException(string);
        }
    }

    public static Map createMapFromEscapedString(String string, boolean bl2) {
        IntersectableHashMap intersectableHashMap = new IntersectableHashMap();
        if (bl2) {
            BracketParser.fillMapWithMandatoryValuesFromEscaped(string, intersectableHashMap);
        } else {
            BracketParser.fillNonEmptyMapWithMandatoryValuesFromEscaped(string, intersectableHashMap);
        }
        return intersectableHashMap;
    }
}

