/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import java.math.BigInteger;

public abstract class MyBigInteger {
    private static final char[] jT = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_-".toCharArray();
    private static final char[] jU = MyBigInteger.bn();

    private static char[] bn() {
        char[] cArray = new char[96];
        int n2 = 0;
        while (n2 < jT.length) {
            cArray[MyBigInteger.jT[n2] - 32] = (char)n2;
            ++n2;
        }
        return cArray;
    }

    public static BigInteger getBigInteger(String string) {
        char[] cArray = string.toCharArray();
        BigInteger bigInteger = BigInteger.ZERO;
        int n2 = 0;
        while (n2 < cArray.length) {
            bigInteger = bigInteger.shiftLeft(6).add(BigInteger.valueOf(jU[cArray[n2] - 32]));
            ++n2;
        }
        return bigInteger;
    }

    public static String toString(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return "0";
        }
        BigInteger bigInteger2 = bigInteger.abs();
        char[] cArray = new char[(bigInteger2.bitLength() - 1) / 6 + 1];
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            long l2 = 0xFFFFFFFFFFFFFFFL;
            long l3 = bigInteger2.longValue() & 0xFFFFFFFFFFFFFFFL;
            bigInteger2 = bigInteger2.shiftRight(60);
            while (l2 > 0L && n2 >= 0) {
                cArray[n2--] = jT[(int)(l3 & 0x3FL)];
                l3 >>= 6;
                l2 >>= 6;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(cArray.length + 1);
        if (bigInteger.signum() < 0) {
            stringBuilder.append('-');
        }
        stringBuilder.append(new String(cArray));
        return stringBuilder.toString();
    }
}

