/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.util;

import be.SIRAPRISE.util.PrematureEOFException;
import be.erwinsmout.MyMessageFormat;
import java.io.DataInputStream;
import java.io.UTFDataFormatException;

public class MyDataInputStream {
    public static String getBigUTFString(DataInputStream dataInputStream) {
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        StringBuffer stringBuffer = new StringBuffer(n2);
        byte[] byArray = new byte[n3];
        int n4 = 0;
        dataInputStream.readFully(byArray, 0, n3);
        while (n4 < n3) {
            int n5 = byArray[n4] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n4;
                    stringBuffer.append((char)n5);
                    break;
                }
                case 12: 
                case 13: {
                    if ((n4 += 2) > n3) {
                        throw new UTFDataFormatException();
                    }
                    byte by2 = byArray[n4 - 1];
                    if ((by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    char c2 = (char)((n5 & 0x1F) << 6 | by2 & 0x3F);
                    stringBuffer.append(c2);
                    break;
                }
                case 14: {
                    if ((n4 += 3) > n3) {
                        throw new UTFDataFormatException();
                    }
                    byte by2 = byArray[n4 - 2];
                    byte by3 = byArray[n4 - 1];
                    if ((by2 & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    char c2 = (char)((n5 & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0);
                    stringBuffer.append(c2);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(stringBuffer);
    }

    public static String getSmallUTFString(DataInputStream dataInputStream) {
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        String string = MyDataInputStream.getUTFString(dataInputStream, s2, s3);
        return string;
    }

    public static String getUTFString(DataInputStream dataInputStream, int n2, int n3) {
        char[] cArray = new char[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2 && n5 < n3) {
            char c2;
            int n6 = dataInputStream.readUnsignedByte();
            ++n5;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    c2 = (char)n6;
                    break;
                }
                case 12: 
                case 13: {
                    int n7 = dataInputStream.readUnsignedByte();
                    ++n5;
                    if ((n7 & 0xC0) != 128) {
                        throw new UTFDataFormatException(MyMessageFormat.format("Received UTF byte 2 {0}.", new String[]{Integer.toHexString(n7)}));
                    }
                    c2 = (char)((n6 & 0x1F) << 6 | n7 & 0x3F);
                    break;
                }
                case 14: {
                    int n7 = dataInputStream.readUnsignedByte();
                    ++n5;
                    int n8 = dataInputStream.readUnsignedByte();
                    ++n5;
                    if ((n7 & 0xC0) != 128 || (n8 & 0xC0) != 128) {
                        throw new UTFDataFormatException(MyMessageFormat.format("Received UTF bytes 2-3 {0}-{1}.", new String[]{Integer.toHexString(n7), Integer.toHexString(n8)}));
                    }
                    c2 = (char)((n6 & 0xF) << 12 | (n7 & 0x3F) << 6 | (n8 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException(MyMessageFormat.format("First UTF byte {0} received.", new String[]{Integer.toHexString(n6)}));
                }
            }
            cArray[n4++] = c2;
        }
        if (n4 != n2 || n5 != n3) {
            throw new UTFDataFormatException(MyMessageFormat.format("Specified byte length {0} and char length {1} did not match with UTF data found.  Processed {2} bytes and found {3} chars.", new String[]{Integer.toString(n3), Integer.toString(n2), Integer.toString(n5), Integer.toString(n4)}));
        }
        return new String(cArray);
    }

    public static byte[] readExactNumberOfBytes(DataInputStream dataInputStream, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 != n2) {
            int n4 = dataInputStream.read(byArray, n3, n2 - n3);
            if (n4 < 0) {
                throw new PrematureEOFException(n3, n2);
            }
            n3 += n4;
        }
        return byArray;
    }
}

