/**
 * 
 */
package be.erwinsmout;

import java.io.Console;

/**
 * Provides a Console.format() method targeted at the System console, and that quietly disregards the case where the System console is null, thus avoiding a nullpointerexception
 * 
 * @author Erwin
 */
public class MyConsole {

	/**
	 * Displays the given consoleMessage on the System console, unless the System console is null.
	 * 
	 * @param consoleMessage
	 *            A message to be displayed on the system console
	 */
	public static void format (String consoleMessage) {
		Console console = System.console();
		if (console != null) {
			console.format(consoleMessage);
		}
	}

	/**
	 * prevent instantiation
	 */
	private MyConsole() {
		
	}
}
