/*
 * Created on 2-okt-2008
 */
package be.erwinsmout;

import java.text.MessageFormat;

/**
 * Provides a MessageFormat.format() method that relieves localizers of having to know whether or not they should be typing single or double quotes in order to obtain a single quote. Before invoking the MessageFormat.format() method, ALL quotes in the pattern are replaced with two single quotes, so that a quote in the input pattern will NEVER be interpreted as a MessageFormat.format() meta-character.
 * 
 * @author Erwin Smout
 */
public class MyMessageFormat {

	/**
	 * formats a message by filling in a pattern with values taken from the given array of parameters. Prior to invoking the standard java MessageFormat.format() method, all single quotes (') in the pattern are replaced with double quotes (''), such that a quote will NEVER be interpreted as a MessageFormat.format() meta-character.
	 * 
	 * @param pattern
	 *            The pattern
	 * @param parameters
	 *            The parameters
	 * @return the formatting result
	 */
	public static String format (String pattern, Object[] parameters) {
		return MessageFormat.format(pattern.replaceAll("'", "''"), parameters); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * prevent instantiation
	 */
	private MyMessageFormat ( ) {

	}
}