/**
 * 
 */
package be.erwinsmout;

import java.util.*;
import java.util.Map.Entry;

/**
 * @author Erwin
 * 
 */
public abstract class MyPropertiesInInsertionOrder extends MyProperties {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2158113867953010071L;

	/**
	 * 
	 */
	private LinkedHashMap<Object, Object> insertionOrderMap;

	/**
	 * @return
	 */
	private synchronized LinkedHashMap<Object, Object> alloc ( ) {
		return (insertionOrderMap == null ? (insertionOrderMap = new LinkedHashMap<Object, Object>()) : insertionOrderMap);
	}

	/**
	 * 
	 */
	public MyPropertiesInInsertionOrder ( ) {
		this(false);
	}

	/**
	 * Creates the Properties object, and tries to load it from one of the following places:
	 * <ol>
	 * <li>A resource available to this' classloader</li>
	 * <li>A file in the directory pointed to by the user.dir system property</li>
	 * <li>A file in the directory pointed to by the user.home system property</li>
	 * </ol>
	 * 
	 * @param resolveSystemPropertyReferences
	 *            flag to indicate whether System property references (e.g.${user.home}) are to be resolved when loading the properties
	 * 
	 */
	public MyPropertiesInInsertionOrder (boolean resolveSystemPropertyReferences) {
		super(resolveSystemPropertyReferences);
	}

	/**
	 * Creates the MyProperties
	 * 
	 * @param defaults
	 */
	public MyPropertiesInInsertionOrder (Properties defaults) {
		this(defaults, false);
	}

	/**
	 * Creates the MyProperties
	 * 
	 * @param defaults
	 * @param resolveSystemPropertyReferences
	 *            flag to indicate whether System property references (e.g.${user.home}) are to be resolved when loading the properties
	 */
	public MyPropertiesInInsertionOrder (Properties defaults, boolean resolveSystemPropertyReferences) {
		super(defaults, resolveSystemPropertyReferences);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Hashtable#clear()
	 */
	@Override
	public synchronized void clear ( ) {
		super.clear();
		alloc().clear();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Hashtable#entrySet()
	 */
	@Override
	public Set<Entry<Object, Object>> entrySet ( ) {
		return alloc().entrySet();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Hashtable#keySet()
	 */
	@Override
	public Set<Object> keySet ( ) {
		return alloc().keySet();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Hashtable#put(java.lang.Object, java.lang.Object)
	 */
	@Override
	public synchronized Object put (Object key, Object value) {
		final Object x = super.put(key, value);
		alloc().put(key, value);
		return x;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Hashtable#remove(java.lang.Object)
	 */
	@Override
	public synchronized Object remove (Object key) {
		alloc().remove(key);
		return super.remove(key);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Hashtable#values()
	 */
	@Override
	public Collection<Object> values ( ) {
		return alloc().values();
	}
}
