/**
 * 
 */
package be.erwinsmout;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/**
 * @author Erwin
 * 
 */
public class MyString {

	/**
	 * Returns a String containing all the Strings in set, in comma-separated syntax
	 * 
	 * @param set
	 *            The set of Strings to be concatenated in comma-separated form
	 * @return a String containing all the Strings in set, in comma-separated syntax
	 */
	public static String asCSV (final Set<String> set) {
		Iterator<String> i = set.iterator();
		String result = ""; //$NON-NLS-1$
		String sep = ""; //$NON-NLS-1$
		while (i.hasNext()) {
			result += (sep + i.next());
			sep = ","; //$NON-NLS-1$
		}
		return result;
	}

	/**
	 * Gets a LinkedList of the non-empty strings which appear in the given input string between any occurrences of the given separator character
	 * 
	 * @param in
	 *            A string to be split, of which the individual nonempty portions are to be returned as a list
	 * @param c
	 *            The separator character
	 * @return a LinkedList of the non-empty strings which appear in the given input string between any occurrences of the given separator character
	 */
	public static LinkedList<String> getNamesInEntryOrder (String in, char c) {
		LinkedList<String> set = new LinkedList<String>();

		String[] names = in.split(Character.toString(c));
		for (String name : names) {
			String trimmedName = name.trim();
			if (trimmedName.length() > 0) {
				set.add(trimmedName);
			}
		}

		return set;

	}

}
