/*
 * Created on 7-feb-2008
 */
package be.erwinsmout;

/**
 * NotFoundExceptions are thrown in SIRA_PRISE to signal to the caller that some search request did not produce a result (or, put otherwise, that the result set produced is actually empty). It is cleaner method of dealing with "NotFound" than returning null references.
 * 
 * @author Erwin Smout
 */
public class NotFoundException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1150699159749429452L;

	/**
	 * Creates the Exception, setting a message argument.
	 * 
	 * @param string
	 *            Some string that might be interesting to be accessible to the caller. The meaning of this String is defined by the particular method that throws the exception. E.g., it might represent the set of all valid command names, ...
	 */
	public NotFoundException (String string) {
		super(string);
	}

	/**
	 * Creates the exception without additional info
	 */
	public NotFoundException ( ) {

	}

}