/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.LogicalValue;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 * 
 */
public abstract class BWSpeciesFunction extends BWWebClientFunction {

	/**
	 * @return
	 * @throws Problem
	 * @throws WAARApplicationException
	 */
	AbstractRelation getMatchingSpecies ( ) throws WAARApplicationException {

		String speciesQuery;
		LogicalValue wv_possibleSpeciesOnly = (LogicalValue) getPresentationValue("POSSIBLESPECIESONLY"); //$NON-NLS-1$
		if (wv_possibleSpeciesOnly != null && wv_possibleSpeciesOnly.getValue()) {
			speciesQuery = BWDBRELVARNAMES.POSSIBLESPECIES;
		} else {
			if (getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME) == null && getPresentationValue(BWDBATTRIBUTENAMES.NLSPECIESNAME) == null && getPresentationValue("SPECIESNAMEPATTERN") == null && getPresentationValue("NLSPECIESNAMEPATTERN") == null) { //$NON-NLS-1$//$NON-NLS-2$
				throw new PleaseEnterSpeciesCriteriaException(getUserLocale());
			}
			speciesQuery = BWDBRELVARNAMES.EXISTINGSPECIES;
		}

		GenericStringValue name = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME);
		GenericStringValue namePattern = (GenericStringValue) getPresentationValue("SPECIESNAMEPATTERN"); //$NON-NLS-1$
		if (name != null) {
			speciesQuery = "JOIN(" + speciesQuery + "," + RelationValueSelectorFactory.getRelationValueSelector(RelationValueSelectorFactory.getNames(name.getString()), BWDBATTRIBUTENAMES.SPECIESNAME, TYPENAMES.STRING) + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} else {
			if (namePattern != null) {
				speciesQuery = "RESTRICT(" + speciesQuery + "," + "MATCHES(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",STRING(" + BracketParser.meta(namePattern.getString()) + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
		}

		GenericStringValue nlName = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.NLSPECIESNAME);
		GenericStringValue nlNamePattern = (GenericStringValue) getPresentationValue("NLSPECIESNAMEPATTERN"); //$NON-NLS-1$
		if (nlName != null) {
			speciesQuery = "SEMIJOIN(" + speciesQuery + ",JOIN(" + BWDBRELVARNAMES.NLSPECIESNAME + "," + RelationValueSelectorFactory.getRelationValueSelector(RelationValueSelectorFactory.getNames(nlName.getString()), BWDBATTRIBUTENAMES.NLSPECIESNAME, TYPENAMES.STRING) + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			speciesQuery = "GROUP(JOIN(" + speciesQuery + "," + BWDBRELVARNAMES.NLSPECIESNAME + "),NLSPECIESNAMELIST(" + BWDBATTRIBUTENAMES.LANGUAGE + "," + BWDBATTRIBUTENAMES.NLSPECIESNAME + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$
		} else {
			if (nlNamePattern != null) {
				String nlNamePatternCondition = "MATCHES(" + BWDBATTRIBUTENAMES.NLSPECIESNAME + ",STRING(" + BracketParser.meta(nlNamePattern.getString()) + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
				String restrictCondition;
				LogicalValue wv_onlyInLanguage = (LogicalValue) getPresentationValue("ONLYINLANGUAGE"); //$NON-NLS-1$
				if (wv_onlyInLanguage != null && wv_onlyInLanguage.getValue()) {
					restrictCondition = "AND(EQ(THE_ISO2(" + BWDBATTRIBUTENAMES.LANGUAGE + "),NAME(" + BracketParser.meta(((GenericStringValue) getPresentationValue("LANGUAGE")).getString()) + "))," + nlNamePatternCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				} else {
					restrictCondition = nlNamePatternCondition;
				}
				speciesQuery = "SEMIJOIN(" + speciesQuery + ",RESTRICT(" + BWDBRELVARNAMES.NLSPECIESNAME + "," + restrictCondition + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$//$NON-NLS-4$
				speciesQuery = "GROUP(JOIN(" + speciesQuery + "," + BWDBRELVARNAMES.NLSPECIESNAME + "),NLSPECIESNAMELIST(" + BWDBATTRIBUTENAMES.LANGUAGE + "," + BWDBATTRIBUTENAMES.NLSPECIESNAME + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$
			} else {
				speciesQuery = "LEFTJOIN(" + speciesQuery + ",GROUP(" + BWDBRELVARNAMES.NLSPECIESNAME + ",NLSPECIESNAMELIST(" + BWDBATTRIBUTENAMES.LANGUAGE + "," + BWDBATTRIBUTENAMES.NLSPECIESNAME + ")),NLSPECIESNAMELIST(RELATION(HEADING(" + BWDBATTRIBUTENAMES.LANGUAGE + "(LANGUAGE)" + BWDBATTRIBUTENAMES.NLSPECIESNAME + "(STRING))BODY())))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			}
		}

		speciesQuery = "EXTEND(" + speciesQuery + ",ISPOSSIBLE(EQ(TABLE_DEE,PROJECT(SEMIJOIN(RENAME(" + BWDBRELVARNAMES.POSSIBLESPECIES + ",(SPECIESNAME,POSSIBLESPECIESNAME)),RELATION(HEADING(POSSIBLESPECIESNAME(STRING))BODY(TUPLE(POSSIBLESPECIESNAME(" + BWDBATTRIBUTENAMES.SPECIESNAME + "))))),()))))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			return dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.READONLY).execQueryAndEndTransaction(speciesQuery); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}
}
